% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderNodes.R
\name{nodeOrder}
\alias{nodeOrder}
\title{Order nodes in descending order of \emph{weighted degree} and order 
modules by the similarity of their summary vectors.}
\usage{
nodeOrder(
  network,
  data,
  correlation,
  moduleAssignments = NULL,
  modules = NULL,
  backgroundLabel = "0",
  discovery = NULL,
  test = NULL,
  na.rm = FALSE,
  orderModules = TRUE,
  mean = FALSE,
  simplify = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{network}{a list of interaction networks, one for each dataset. Each 
entry of the list should be a \eqn{n * n} matrix or where each element 
contains the edge weight between nodes \eqn{i} and \eqn{j} in the inferred 
network for that dataset.}

\item{data}{a list of matrices, one for each dataset. Each entry of the list 
should be the data used to infer the interaction \code{network} for that 
dataset. The columns should correspond to variables in the data
(nodes in the network) and rows to samples in that dataset.}

\item{correlation}{a list of matrices, one for each dataset. Each entry of
the list should be a \eqn{n * n} matrix where each element contains the 
correlation coefficient between nodes \eqn{i} and \eqn{j} in the 
\code{data} used to infer the interaction network for that dataset.}

\item{moduleAssignments}{a list of vectors, one for each \emph{discovery} 
dataset, containing the module assignments for each node in that dataset.}

\item{modules}{a list of vectors, one for each \code{discovery} dataset, 
of modules to perform the analysis on. If unspecified, all modules
in each \code{discovery} dataset will be analysed, with the exception of 
those specified in \code{backgroundLabel} argument.}

\item{backgroundLabel}{a single label given to nodes that do not belong to 
any module in the \code{moduleAssignments} argument. Defaults to "0". Set 
to \code{NULL} if you do not want to skip the network background module.}

\item{discovery}{a vector of names or indices denoting the \emph{discovery}
dataset(s) in the \code{data}, \code{correlation}, \code{network}, 
\code{moduleAssignments}, \code{modules}, and \code{test} lists.}

\item{test}{a list of vectors, one for each \code{discovery} dataset,
of names or indices denoting the \emph{test} dataset(s) in the \code{data}, 
\code{correlation}, and \code{network} lists.}

\item{na.rm}{logical; If \code{TRUE}, nodes and modules present in the 
\code{discovery} dataset but missing from the test dataset are excluded. If
\code{FALSE}, missing nodes and modules are put last in the ordering.}

\item{orderModules}{logical; if \code{TRUE} modules ordered by clustering 
their summary vectors. If \code{FALSE} modules are returned in the order
provided.}

\item{mean}{logical; if \code{TRUE}, node order will be calculated for each
\code{discovery} dataset by averaging the weighted degree and pooling 
\emph{module summary} vectors across the specified \code{test} datasets.
If \code{FALSE}, the node order is calculated separately in each test 
dataset.}

\item{simplify}{logical; if \code{TRUE}, simplify the structure of the output
list if possible (see Return Value).}

\item{verbose}{logical; should progress be reported? Default is \code{TRUE}.}
}
\value{
A nested list structure. At the top level, the list has one element per 
 \code{'discovery'} dataset. Each of these elements is a list that has one
 element per \code{'test'} dataset analysed for that \code{'discovery'} 
 dataset. Each of these elements is a list that has one element per 
 \code{'modules'} specified, containing a vector of node names for the
 requested module. When \code{simplify = TRUE} then the simplest possible 
 structure will be returned. E.g. if the node ordering are requested for 
 module(s) in only one dataset, then a single vector of node labels will
 be returned. 
 
When \code{simplify = FALSE} then a nested list of datasets will always be 
returned, i.e. each element at the top level and second level correspond to 
a dataset, and each element at the third level will correspond to modules 
discovered in the dataset specified at the top level if module labels are 
provided in the corresponding \code{moduleAssignments} list element. E.g. 
\code{results[["Dataset1"]][["Dataset2"]][["module1"]]} will contain the 
order of nodes calculated in "Dataset2", where "module1" was indentified in
"Dataset1". Modules and datasets for which calculation of the node order 
have not been requested will contain \code{NULL}.
}
\description{
Order nodes in descending order of \emph{weighted degree} and order 
modules by the similarity of their summary vectors.
}
\details{
\subsection{Input data structures:}{
  The \link[=modulePreservation]{preservation of network modules} in a second
  dataset is quantified by measuring the preservation of topological
  properties between the \emph{discovery} and \emph{test} datasets. These 
  properties are calculated not only from the interaction networks inferred
  in each dataset, but also from the data used to infer those networks (e.g.
  gene expression data) as well as the correlation structure between 
  variables/nodes. Thus, all functions in the \code{NetRep} package have the 
  following arguments: 
  \describe{
    \item{\code{network}:}{
      a list of interaction networks, one for each dataset.
    }
    \item{\code{data}:}{
      a list of data matrices used to infer those networks, one for each 
      dataset.
    }
    \item{\code{correlation}:}{
     a list of matrices containing the pairwise correlation coefficients 
     between variables/nodes in each dataset.
    } 
    \item{\code{moduleAssignments}:}{
     a list of vectors, one for each \emph{discovery} dataset, containing 
     the module assignments for each node in that dataset.
    }
    \item{\code{modules}:}{
     a list of vectors, one for each \emph{discovery} dataset, containing
     the names of the modules from that dataset to analyse.  
    }
    \item{\code{discovery}:}{
      a vector indicating the names or indices of the previous arguments' 
      lists to use as the \emph{discovery} dataset(s) for the analyses.
    }
    \item{\code{test}:}{
      a list of vectors, one vector for each \emph{discovery} dataset, 
      containing the names or indices of the \code{network}, \code{data}, and 
      \code{correlation} argument lists to use as the \emph{test} dataset(s) 
      for the analysis of each \emph{discovery} dataset.
    }
  }
  
  The formatting of these arguments is not strict: each function will attempt
  to make sense of the user input. For example, if there is only one 
  \code{discovery} dataset, then input to the \code{moduleAssigments} and 
  \code{test} arguments may be vectors, rather than lists. If the 
  \code{nodeOrder} are being calculate within the \emph{discovery} or
  \emph{test} datasets, then the \code{discovery} and \code{test} arguments do
  not need to be specified, and the input matrices for the \code{network},
  \code{data}, and \code{correlation} arguments do not need to be wrapped in
  a list.
}
\subsection{Analysing large datasets:}{
  Matrices in the \code{network}, \code{data}, and \code{correlation} lists
  can be supplied as \code{\link{disk.matrix}} objects. This class allows 
  matrix data to be kept on disk and loaded as required by \pkg{NetRep}. 
  This dramatically decreases memory usage: the matrices for only one 
  dataset will be kept in RAM at any point in time.
}
\subsection{Mean weighted degree:}{
   When multiple \code{'test'} datasets are specified and \code{'mean'} is
   \code{TRUE}, then the order of nodes will be determine by the average of
   each node's weighted degree across datasets. The weighted degree in each 
   dataset is scaled to the node with the maximum weighted degree in that
   module in that dataset: this prevents differences in average edge weight 
   across datasets from influencing the outcome (otherwise the mean would be
   weighted by the overall density of connections in the module). Thus, the 
   mean weighted degree is a robust measure of a node's relative importance 
   to a module across datasets. The mean is calculated with 
   \code{'na.rm=TRUE'}: where a node is missing it does not contribute to 
   the mean.
 }
}
\examples{
# load in example data, correlation, and network matrices for a discovery
# and test dataset:
data("NetRep")

# Set up input lists for each input matrix type across datasets. The list
# elements can have any names, so long as they are consistent between the
# inputs.
network_list <- list(discovery=discovery_network, test=test_network)
data_list <- list(discovery=discovery_data, test=test_data)
correlation_list <- list(discovery=discovery_correlation, test=test_correlation)
labels_list <- list(discovery=module_labels)

# Sort modules by similarity and nodes within each module by their weighted 
# degree
nodes <- nodeOrder(
  network=network_list, data=data_list, correlation=correlation_list,  
  moduleAssignments=labels_list
)

}
\references{
\enumerate{
   \item{
     Langfelder, P., Mischel, P. S. & Horvath, S. \emph{When is hub gene 
     selection better than standard meta-analysis?} PLoS One \strong{8}, 
     e61505 (2013).
   }
}
}
\seealso{
\code{\link{networkProperties}}
}
\keyword{internal}
\keyword{utilities}
