% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WQDCrecursive.R
\name{WQDCrecursive}
\alias{WQDCrecursive}
\title{Compute the Recursive Weighted Quartet Distance Consensus tree from gene tree data}
\usage{
WQDCrecursive(rqt, method = fastme.bal, stopAt = 2, terminal = 1)
}
\arguments{
\item{rqt}{a resolved quartet table as produced by \code{quartetTableResolved}}

\item{method}{a distance-based tree building function, such as \code{fastme.bal} or \code{nj}}

\item{stopAt}{a non-negative branch length in coalescent units; recursive calls stop when the longest 
branch in a recursively examined subtree is smaller than this value}

\item{terminal}{non-negative branch length to supply for terminal branches,
whose lengths cannot be inferred by \code{WQDCrecursive}}
}
\value{
an unrooted metric tree, of type phylo
}
\description{
Infer a metric species tree from counts
of quartets displayed on a collection of gene trees, as described by 
\insertCite{YR19;textual}{MSCquartets}. Edge lengths are in coalescent units.
}
\details{
The algorithm counts quartets displayed on the gene trees, builds a tree using \code{WQDS},
determines the split corresponding to the longest edge in that tree,
and then recursively builds trees
on the taxa in each split set together with a `composite taxon' formed by all
taxa in the other split set.
This approach is slower than non-recursive \code{WQDC}, but increases topological accuracy. Shorter branch 
lengths tend to be more accurately estimated.

This function must be called with its argument a resolved quartet
table of size (n choose 4)x(n+3). Its recursive nature
requires building smaller resolved quartet tables on split sets with an additional
composite taxon.
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
tnames=taxonNames(gtrees)
QT=quartetTable(gtrees,tnames[1:6])
RQT=quartetTableResolved(QT)
stree=WQDCrecursive(RQT)
write.tree(stree)
plot(stree)

}
\references{
\insertRef{YR19}{MSCquartets}
}
\seealso{
\code{\link{quartetTableResolved}},\code{\link{quartetTable}},
\code{\link{QDC}}, \code{\link{QDS}}, \code{\link{quartetTableCollapse}}
}
