% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Rats}
\alias{Rats}
\title{Teratology study}
\format{
A data frame with 58 observations on the following 5 variables
\describe{
  \item{\code{litter}}{litter index}
  \item{\code{group}}{group index (\code{1}, \ldots, \code{4})}
  \item{\code{h}}{hemoglobin level of the mother}
  \item{\code{n}}{number of fetuses in the litter}
  \item{\code{s}}{number of dead fetuses in the litter}
}
}
\source{
Agresti, A. (2015). \emph{Foundations of Linear and Generalized Linear Models}. Hoboken: Wiley.

 Package \code{catdata}
}
\usage{
Rats
}
\description{
Teratology experiment investigating effects of dietary regimens or chemical agents on the fetal
development of rats in a laboratory setting. The experiment, as describred in Agresti (2015, Section 8.2.4),
regards female rats on iron-deficient diets, assigned to four groups. Rats in group 1 were given placebo
injections, and rats in other groups were given injections of an iron supplement.
This was done on days 7 and 10 in group 2, on days 0 and 7 in group 3, and weekly in group 4.
The 58 rats were made pregnant, sacrificed after 3 weeks, and then the total number of dead fetuses
was counted in each litter, as was the mother’s hemoglobin level.
}
\references{
Moore, D.F. and Tsiatis, A. (1991). Robust estimation of the variance in moment methods for
 extra-binomial and extra-Poisson variation. \emph{Biometrics}, \bold{47}, 383-401.
}
\keyword{datasets}
