% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cv.estimateSpikes}
\alias{cv.estimateSpikes}
\title{Cross-validate and optimize model parameters}
\usage{
cv.estimateSpikes(dat, type = "ar1", gam = NULL, lambdas = NULL,
  nLambdas = 10, hardThreshold = TRUE)
}
\arguments{
\item{dat}{fluorescence trace (a vector)}

\item{type}{type of model, must be one of AR(1) 'ar1', or AR(1) with intercept 'intercept'}

\item{gam}{a scalar value for the AR(1)/AR(1) + intercept decay parameter}

\item{lambdas}{vector of tuning parameters to use in cross-validation}

\item{nLambdas}{number of tuning parameters to estimate the model (grid of values is automatically produced)}

\item{hardThreshold}{boolean specifying whether the calcium concentration must be non-negative (in the AR-1 problem)}
}
\value{
A list of values corresponding to the 2-fold cross-validation:

\code{cvError} the MSE for each tuning parameter

\code{cvSE} the SE for the MSE for each tuning parameter

\code{lambdas} tuning parameters

\code{optimalGam} matrix of (optimized) parameters, rows correspond to tuning parameters, columns correspond to optimized parameter

\code{lambdaMin} tuning parameter that gives the smallest MSE

\code{lambda1SE} 1 SE tuning parameter

\code{indexMin} the index corresponding to lambdaMin

\code{index1SE} the index corresponding to lambda1SE
}
\description{
Cross-validate and optimize model parameters
}
\details{
We perform cross-validation over a one-dimensional grid of \eqn{\lambda} values.
 For each value of \eqn{\lambda} in this grid, we solve the corresponding optimization problem, that is, one of

\strong{AR(1)-model:}
minimize_{c1,...,cT} 0.5 sum_{t=1}^T ( y_t - c_t )^2 + lambda sum_{t=2}^T 1_{c_t neq gamma c_{t-1} }
for the global optimum, where $y_t$ is the observed fluorescence at the tth
timepoint.

If hardThreshold = T then the additional constraint
c_t >= 0 is added to the optimzation problem above.


\strong{AR(1) with intercept:}
minimize_{c1,...,cT,b1,...,bT} 0.5 sum_{t=1}^T (y_t - c_t - b_t)^2 + lambda sum_{t=2}^T 1_{c_t neq gamma c_{t-1}, b_t neq b_{t-1} }
where the indicator variable 1_{(A,B)} equals 1 if the event A cup B holds, and equals zero otherwise.

on a training set using a candidate value for \eqn{\gamma}. Given the resulting set of changepoints, we solve a constrained optimization problem for \eqn{\gamma}. We then refit the optimization problem with the optimized value of \eqn{\gamma},
and then evaluate the mean squared error (MSE) on a hold-out set. Note that in the final output of the algorithm,
we take the square root of the optimal value of \eqn{\gamma} in order to address the fact that the cross-validation
scheme makes use of training and test sets consisting of alternately-spaced timesteps.

If there is a tuning parameter lambdaT in the path [lambdaMin, lambdaMax] that produces a fit with
less than 1 spike per 10,000 timesteps the path is truncated to [lambdaMin, lambdaT] and a warning is produced.

See Algorithm 3 of Jewell and Witten (2017) <arXiv:1703.08644>
}
\examples{
# Not run
# sim <- simulateAR1(n = 500, gam = 0.998, poisMean = 0.009, sd = 0.05, seed = 1)
# plot(sim)

# AR(1) model
# outAR1 <- cv.estimateSpikes(sim$fl, type = "ar1")
# plot(outAR1)
# print(outAR1)
# fit <- estimateSpikes(sim$fl, gam = outAR1$optimalGam[outAR1$index1SE, 1],
# lambda = outAR1$lambda1SE, type = "ar1")
# plot(fit)
# print(fit)

# AR(1) + intercept model
# outAR1Intercept <- cv.estimateSpikes(sim$fl, type = "intercept",
# lambdas = seq(0.1, 5, length.out = 10))
# plot(outAR1Intercept)
# print(outAR1Intercept)
# fit <- estimateSpikes(sim$fl, gam = outAR1Intercept$optimalGam[outAR1Intercept$index1SE, 1],
# lambda = outAR1Intercept$lambda1SE, type = "intercept")
# plot(fit)
# print(fit)
}
\seealso{
\strong{Estimate spikes:}
\code{\link{estimateSpikes}},
\code{\link{print.estimatedSpikes}},
\code{\link{plot.estimatedSpikes}}.

\strong{Cross validation:}
\code{\link{cv.estimateSpikes}},
\code{\link{print.cvSpike}},
\code{\link{plot.cvSpike}}.

\strong{Simulation:}
\code{\link{simulateAR1}},
\code{\link{plot.simdata}}.
}
