% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPZone_request.R
\name{HPZone_request_query}
\alias{HPZone_request_query}
\title{Performs a HPZone request with the given parameters.}
\usage{
HPZone_request_query(query, ..., scope = API_env$scope_standard)
}
\arguments{
\item{query}{A GraphQL query to send to the HPZone API. Note that only the actual query is required. (See the examples.)}

\item{...}{Parameters to be passed to [sprintf()]. If empty, the body is not passed through [sprintf()].}

\item{scope}{The desired scope; either standard or extended.}
}
\value{
An object containing the requested data points. This can be in different forms, depending on the request, but is simplified as much as possible.
}
\description{
This function is a convenience wrapper around [HPZone_request_raw()], to facilitate easier coding.
This function integrates [sprintf()] to allow for easier query design, quotes are automatically escaped, and the the result is unlisted to allow for easier access.
See the example for differences with [HPZone_request_raw()]. Note that results are *not* automatically paginated; use [HPZone_request_paginated()] for that.
}
\examples{
# Note the difference between the raw and convenience functions.
# These lines are equal:
\dontrun{
HPZone_request("cases", c("Case_creation_date", "Case_number"),
               where=c("Case_creation_date", ">=", "2025-01-01"))
HPZone_request_query(paste0('cases(where: {',
                              'Case_creation_date: { gte: "2025-01-01" }',
                            '}) {',
                              'items { Case_creation_date, Case_number }',
                             '}'))
HPZone_request_raw(paste0('{"query": "{ cases(where: {',
                            'Case_creation_date: { gte: \\\\"2025-01-01\\\\" }',
                          '}) {',
                            'items { Case_creation_date, Case_number }',
                          '} }"}'))
}
}
\seealso{
[HPZone_request()], [HPZone_request_paginated()], [HPZone_convert_dates()]
}
