collar.bls=function(S,K1,K2,r,t,sd,plot=FALSE){

  all=list(S,K1,K2,r,t,sd,plot)
  #NULL
  if(any(lapply(all,is.null)==T)) stop("Cannot input any variables as NULL.")
  #Length
  if(any(lapply(all,length) != 1)==T) stop("All variables must be of length 1.")
  #Numeric
  num2=list(S,K1,K2,r,t,sd)
  na.num2=num2[which(lapply(num2,is.na)==F)]
  if(any(lapply(na.num2,is.numeric)==F)) stop("S K1, K2, r, t, and sd must be numeric.")
  #NA
  if(any(lapply(all,is.na)==T)) stop("Cannot input any variables as NA.")

  NA.Neg=array(c(r,S,K1,K2,t,sd))
  #Positive
  if(any(NA.Neg<=0)) stop("All numeric variables must be positive.")
  #Infinite
  if(any(NA.Neg==Inf)) stop("Cannot input any variables as infinite.")
  #Logical
  stopifnot(is.logical(plot))

  if(K1>=K2) stop("K1 must be less than K2.")
  if(K2<=S | K1>=S) stop("K2 must be > S and K1 must be < S")

  d1 = (log(S/K1)+(r+sd^2/2)*t)/(sd*sqrt(t))
  d2 = d1 - sd * sqrt(t)
  putP = K1*exp(-r*t) * pnorm(-d2) - S*pnorm(-d1)
  d1 = (log(S/K2)+(r+sd^2/2)*t)/(sd*sqrt(t))
  d2 = d1 - sd * sqrt(t)
  callP = S*pnorm(d1) - K2*exp(-r*t)*pnorm(d2)

  stock=unique(round(seq(0,K1,length.out=6)))
  stock=c(stock,round(seq(K1,K2,length.out=4)))
  stock=c(stock,round(seq(K2,K2+K1,length.out=6)))
  stock=unique(stock)
  stock2=unique(round(c(seq(0,K1,length.out=6),seq(K2,K2+K1,length.out=6))))
  payoff=rep(0,length(stock))
  profit=rep(0,length(stock))
  for(i in 1:length(stock)){
    if(stock[i]<=K1) payoff[i]=K1-stock[i]
    if(stock[i]>=K2) payoff[i]=K2-stock[i]
    if(stock[i]<K2 & stock[i]>K1) payoff[i]=0
    profit[i]=payoff[i]+(callP-putP)*exp(r*t)
  }

  if(plot==T){
    plot(stock,profit,type="l",xlab="Stock Price",main="Collar\nPayoff and Profit",ylab="$",
         ylim=c(min(profit,payoff),max(profit,payoff)),xaxt='n',yaxt='n',col="steelblue",lwd=2)
    lines(stock,payoff,lty=2,lwd=2,col="firebrick")
    abline(h=0,lty=2,col="gray")
    y=round(seq(min(payoff,profit),max(payoff,profit),length.out=8))
    axis(2,at=y,labels=y,las=2)
    axis(1,at=if(K2-K1<7) stock2[-which(stock2==K2)] else stock2,las=2)
    legend("bottomleft",c("Profit","Payoff"),lty=c(1,2),col=c("steelblue","firebrick"),lwd=c(2,2))  }

  out1=data.frame(stock,payoff,profit)
  names(out1)=c("Stock Price","Payoff","Profit")
  out2=matrix(c(putP,callP,putP-callP),nrow=3)
  rownames(out2)=c("Put (K1)","Call (K2)","Net Cost")
  colnames(out2)=c("Premiums")
  out=list(Payoff=out1,Premiums=out2)
  return(out)
}
