% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_data.R
\name{gen_data}
\alias{gen_data}
\title{Generate Toy Data for Matching}
\usage{
gen_data(n = 250, p = 5, write = FALSE, path = getwd(), filename = "AME.csv")
}
\arguments{
\item{n}{Number of units desired in the data set. Defaults to 250.}

\item{p}{Number of covariates in the data set. Must be greater than 2.
Defaults to 5.}

\item{write}{A logical scalar. If \code{TRUE}, the resulting data is stored
as a .csv file as specified by arguments \code{path} and \code{filename}.
Defaults to \code{FALSE}.}

\item{path}{The path to the location where the data should be written if
\code{write = TRUE}. Defaults to \code{getwd()}.}

\item{filename}{The name of the file to which the data should be written if
\code{write = TRUE}. Defaults to AME.csv.}
}
\value{
A data frame that may be passed to \code{\link{FLAME}} or
  \code{\link{DAME}}. Covariates are numeric, treatment is binary numeric and
  outcome is numeric.
}
\description{
\code{gen_data} generates toy data that can be used to explore FLAME and DAME
functionality.
}
\details{
\code{gen_data} simulates data in the format accepted by \code{\link{FLAME}}
and \code{link{DAME}}. Covariates \eqn{X_i} and treatment \eqn{T} are both
independently generated according to a Bernoulli(0.5) distribution. The
outcome \eqn{Y} is generated according to \eqn{Y = 15X_1 - 10X_2 + 5X_3 + 5T
+ \epsilon}, where \eqn{\epsilon \sim N(0, I_n)}. Thus, the value of \code{p}
must be at least 3 and any additional covariates beyond \eqn{X_1, X_2, X_3}
are irrelevant.
}
