% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSSMod.R
\docType{data}
\name{DoctorRWM}
\alias{DoctorRWM}
\title{German doctor first visits data}
\format{A data frame with 7293 observations of 26 variables as below;
\describe{
 \item{ID}{identification number (numeric)}
 \item{FEMALE}{female or not (categorical)}
 \item{YEAR}{year (categorical)}
 \item{AGE}{age (numeric)}
 \item{HSAT}{health satisfaction coded 0 (low) to 10 (high) (numeric)}
 \item{HANDDUM}{person is handicappe or not (categorical)}
 \item{HANDPER}{percentage degree of handicap (numeric)}
 \item{HHNINC}{monthly household net income (numeric)}
 \item{HHKIDS}{child (ren) below age 16 in household (numeric)}
 \item{EDUC}{years of schooling (numeric)}
 \item{MARRIED}{person is married or not (categorical)}
 \item{HAUPTS}{level of schooling (categorical)}
 \item{REALS}{level of schooling (categorical)}
 \item{FACHHS}{level of schooling (categorical)}
 \item{ABITUR}{level of schooling (categorical)}
 \item{UNIV}{level of schooling (categorical)}
 \item{WORKING}{employed or not (categorical)}
 \item{BLUEC}{person is blue collar worker or not (categorical)}
 \item{WHITEC}{person is white collar worker or not (categorical)}
 \item{SELF}{person is self-employed or not (categorical)}
 \item{BEAMT}{civil servant or not (categorical)}
 \item{DOCVIS}{number of doctor visits in last 3 months (numeric)}
 \item{HOSPVIS}{number of hospital visits last year (numeric)}
 \item{PUBLIC}{person is insured in public health insurance or not (categorical)}
 \item{ADDON}{person is insured in add-on insurance or not (categorical)}
 \item{INCOME_SCALE}{scaled income; original income/1000 (numeric)}
}}
\source{
Riphahn, R. T., Wambach, A. and Million, A. (2003) Incentive Effects
in the Demand for Health Care: A Bivariate Panel Count Data Estimation,
 \emph{Journal of Applied Econometrics}, \strong{18}, 4, 387--405.
 Published online 8 October 2002.
\url{https://doi.org/10.1002/jae.680}

\url{http://qed.econ.queensu.ca/jae/2003-v18.4/riphahn-wambach-million/}
}
\usage{
data(DoctorRWM)
}
\description{
Data is from Riphahn, Wambach and Million (2003), used for studying longitudinal
analysis concerning the usage of the German health insurance system. The original
data contain a few years data for patients, but we have only for first year.
}
\references{
Greene, W. H. (2012) \emph{Econometric Analysis, 7th Edition}. Pearson
education.

Azzalini, A., Kim, H.-M. and Kim, H.-J. (2019) Sample selection
models for discrete and other non-Gaussian response variables.
 \emph{Statistical Methods & Applications}, \strong{28}, 27--56. First online 30 March 2018.
\url{https://doi.org/10.1007/s10260-018-0427-1}
}
\keyword{datasets}
