% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patt_deep.R
\name{deep_response_model}
\alias{deep_response_model}
\title{Response model from experimental data using deep neural learning through Tensorflow}
\usage{
deep_response_model(
  response.formula,
  exp.data,
  exp.compliers,
  compl.var,
  algorithm = "adam",
  hidden.layer = c(2, 2),
  hidden_activation = "relu",
  epoch = 10,
  verbose = 1,
  batch_size = 32,
  output_units = 1,
  validation_split = NULL,
  patience = NULL,
  output_activation = "linear",
  loss = "mean_squared_error",
  metrics = "mean_squared_error",
  dropout_rate = NULL
)
}
\arguments{
\item{response.formula}{formula specifying the response variable and covariates.}

\item{exp.data}{experimental dataset.}

\item{exp.compliers}{\code{data.frame} object of compliers from
\code{complier_predict}.}

\item{compl.var}{string specifying binary complier variable}

\item{algorithm}{string for optimizer algorithm in response model.}

\item{hidden.layer}{vector specifying hidden layers and the number of neurons in each hidden layer}

\item{hidden_activation}{string or vector for activation functions in hidden layers.}

\item{epoch}{integer for number of epochs}

\item{verbose}{1 to display model training information and learning curve plot.
0 to suppress messages and plots.}

\item{batch_size}{batch size to split training data.}

\item{output_units}{integer for units in output layer. Defaults to 1 for continuous and binary outcome variables.
In case of multinomial outcome variable, value should be set to the number of categories.}

\item{validation_split}{double for the proportion of test data to be split as validation in response model.}

\item{patience}{integer for number of epochs with no improvement after which training will be stopped.}

\item{output_activation}{string for activation function in output layer. "linear" is
recommended for continuous outcome variables, and "sigmoid" for binary outcome variables}

\item{loss}{string for loss function. "mean_squared_error" recommended for linear models,
"binary_crossentropy" for binary models.}

\item{metrics}{string for metrics. "mean_squared_error" recommended for linear models,
"binary_accuracy" for binary models.}

\item{dropout_rate}{double or vector for proportion of hidden layer to drop out in response model.}
}
\value{
model object of trained  response model.
}
\description{
Train response model (response variable as outcome and covariates) from all
compliers (actual + predicted) in experimental data using Tensorflow.
}
