% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_data.R
\name{cf_data}
\alias{cf_data}
\title{Contour plot from data}
\usage{
cf_data(
  x,
  y = NULL,
  z = NULL,
  xlim = NULL,
  ylim = NULL,
  xylim = NULL,
  fit = "",
  gg = FALSE,
  show_points,
  family = "gaussian",
  ...
)
}
\arguments{
\item{x}{either just x data, x and y data, or x, y and z data}

\item{y}{either y data, z data, or null}

\item{z}{either z data or null}

\item{xlim}{x limits for the contour plot, will be set to data limits +- 5\% if not specified}

\item{ylim}{y limits for the contour plot, will be set to data limits +- 5\% if not specified}

\item{xylim}{x and y limits for the contour plot}

\item{fit}{Method to fit a model with. Current options are laGP (default),
mlegp, gam (uses mgcv), and locfit. laGP is faster but might cause trouble.}

\item{gg}{If TRUE, will use ggplot2 by calling gcf_func}

\item{show_points}{Whether the input data points should be shown on the plot.
If missing, is TRUE when there are more than 300 points.}

\item{family}{The distribution/link to be used in fitting. Only available
when fit is locfit or mgcv.}

\item{...}{passed to cf_func}
}
\description{
Makes filled contour plot from data without sidebar by interpolating 
with a Gaussian process model.
The model is passed to cf_func to make the contour plot.
}
\examples{
x <- runif(20)
y <- runif(20)
z <- exp(-(x-.5)^2-5*(y-.5)^2)
cf_data(x,y,z)
}
