% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{scottish_CVD_df}
\alias{scottish_CVD_df}
\title{Scottish Health Survey CVD}
\format{
A data frame with 8,804 observations and 8 variables:
\describe{
\item{age}{Respondent age in years (integer)}
\item{sex}{Respondent sex (factor with 2 levels)}
\item{sc}{Social class (factor with 3 levels)}
\item{cvddef}{Doctor-diagnosed CVD status (integer: 0=no, 1=yes)}
\item{carstair}{Carstairs deprivation score (numeric)}
\item{smoke}{Smoking status (factor with 5 levels)}
\item{id}{Respondent identification number (integer)}
\item{area}{Geographic area code (integer)}
}
}
\source{
Data taken from the R2MLwiN package version 0.8-9. Original survey:
1998 Scottish Health Survey. Methodology reference:
Charlton C, Rasbash J, Browne WJ, Healy M, Cameron B (2024).
MLwiN Version 3.09. Centre for Multilevel Modelling, University of Bristol.
}
\usage{
data(scottish_CVD_df)
}
\description{
This dataset, scottish_CVD_df, is a data frame containing cardiovascular health
data from the 1998 Scottish Health Survey. It includes information from 8,804
respondents aged 18-64, with variables covering demographics, health behaviors,
and cardiovascular disease status.
}
\details{
The dataset name has been kept as 'scottish_CVD_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
CardioDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a standard data frame. The original content has not been modified
in any way.
}
