% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{patient_CAV_df}
\alias{patient_CAV_df}
\title{CAV in Heart Transplant Patients}
\format{
A data frame with 2,803 observations and 5 variables:
\describe{
\item{PTNUM}{Patient identification number (integer)}
\item{years}{Time since transplant in years (numeric)}
\item{state}{Disease state (numeric)}
\item{dage}{Donor age in years (integer)}
\item{pdiag}{Primary diagnosis code (numeric)}
}
}
\source{
Data taken from the flexmsm package version 0.1.2. Original data:
Papworth Hospital, UK. Subset of cav data from msm package.
}
\usage{
data(patient_CAV_df)
}
\description{
This dataset, patient_CAV_df, is a data frame containing longitudinal follow-up data
from heart transplant recipients at Papworth Hospital, UK. It tracks 2,803 angiographic
examinations for the onset of cardiac allograft vasculopathy and mortality.
}
\details{
The dataset name has been kept as 'patient_CAV_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
CardioDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a standard data frame. The original content has not been modified
in any way.
}
