% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observ_ts.R
\name{observ_ts}
\alias{observ_ts}
\title{Example of distribution of views -- Student t-distribution}
\usage{
observ_ts(x, q, covmat, df = 5)
}
\arguments{
\item{x}{Data points matrix which collects in rows coordinates of points in which distribution density is  computed.}

\item{q}{Vector of investor's views.}

\item{covmat}{Covariance matrix of the distribution; dispersion matrix \eqn{\Sigma} is computed from \code{covmat}.}

\item{df}{Number of degrees of freedom of Students t-distribution.}
}
\value{
function returns a vector of observation distribution densities in data points x.
}
\description{
Function observ_ts computes density of Student t-distribution of views using the formula \cr
\eqn{f(x) = c_k*(1 +(x-q)^{T}*\Sigma^{-1}*(x-q)/df)^{(-(df+k)/2)}}, \cr
where \eqn{c_k} is a normalization constant (depends on the dimension of \eqn{x} and \eqn{q}) and \eqn{\Sigma} is the dispersion matrix.
}
\examples{
k =3
observ_ts (x = matrix(c(rep(0.5,k),rep(0.2,k)),k,2), q = matrix(0,k,1), covmat = diag(k), 
         df=5)

}
\references{
Kotz, S.,  Nadarajah, S., Multivariate t Distributions and Their Applications. Cambridge University Press,  2004.
}
