% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observ_normal.R
\name{observ_normal}
\alias{observ_normal}
\title{Example of distribution of views -- normal distribution}
\usage{
observ_normal(x, q, covmat)
}
\arguments{
\item{x}{Data points matrix which collects in rows coordinates of points in which distribution density is  computed.}

\item{q}{Vector of investor's views.}

\item{covmat}{Covariance matrix of the distribution.}
}
\value{
function returns a vector of distribution densities in data points x.
}
\description{
Function observ_normal computes density of normal distribution of views using the formula \cr
\eqn{f(x) = c_k*\exp(-((x-q)^{T}*covmat^{-1}*(x-q))/2)},\cr
where \eqn{c_k} is a normalization constant (depends on the dimension of \eqn{x} and \eqn{q}).
}
\examples{
k =3
observ_normal (x = matrix(c(rep(0.5,k),rep(0.2,k)),k,2), q = matrix(0,k,1), 
               covmat = diag(k)) 

}
\references{
Palczewski, J., Palczewski, A., Black-Litterman Model for Continuous Distributions (2016). Available at SSRN: https://ssrn.com/abstract=2744621.
}
