% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{bertopic_save}
\alias{bertopic_save}
\title{Save a BERTopic model}
\usage{
bertopic_save(
  model,
  path,
  serialization = c("pickle", "safetensors", "pt"),
  save_embedding_model = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{model}{A "bertopic_r" model.}

\item{path}{Destination path (file or directory, as required by BERTopic).}

\item{serialization}{One of "pickle", "safetensors", or "pt". Default "pickle".}

\item{save_embedding_model}{Logical; whether to include the embedding model. Default FALSE.}

\item{overwrite}{Logical; if TRUE and the target exists, it will be replaced.}
}
\value{
Invisibly returns the normalized path.
}
\description{
Save a fitted BERTopic model to disk. Depending on the serialization method,
this may produce either a single file (e.g., *.pkl / *.pt / *.safetensors)
or a directory bundle. The function does not pre-create the target path; it
only ensures the parent directory exists and lets BERTopic decide the layout.
}
