% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull.R
\name{workflow-extractors}
\alias{workflow-extractors}
\alias{pull_workflow_preprocessor}
\alias{pull_workflow_spec}
\alias{pull_workflow_fit}
\alias{pull_workflow_mold}
\alias{pull_workflow_prepped_recipe}
\title{Extract elements of a workflow}
\usage{
pull_workflow_preprocessor(x)

pull_workflow_spec(x)

pull_workflow_fit(x)

pull_workflow_mold(x)

pull_workflow_prepped_recipe(x)
}
\arguments{
\item{x}{A workflow}
}
\value{
The extracted value from the workflow, \code{x}, as described in the description
section.
}
\description{
These functions extract various elements from a workflow object. If they do
not exist yet, an error is thrown.
\itemize{
\item \code{pull_workflow_preprocessor()} returns either the formula or recipe used
for preprocessing.
\item \code{pull_workflow_spec()} returns the parsnip model specification.
\item \code{pull_workflow_fit()} returns the parsnip model fit.
\item \code{pull_workflow_mold()} returns the preprocessed "mold" object returned
from \code{\link[hardhat:mold]{hardhat::mold()}}. It contains information about the preprocessing,
including either the prepped recipe or the formula terms object.
\item \code{pull_workflow_prepped_recipe()} returns the prepped recipe. It is
extracted from the mold object returned from \code{pull_workflow_mold()}.
}
}
\examples{
library(parsnip)
library(recipes)

model <- linear_reg()
model <- set_engine(model, "lm")

recipe <- recipe(mpg ~ cyl + disp, mtcars)
recipe <- step_log(recipe, disp)

base_workflow <- workflow()
base_workflow <- add_model(base_workflow, model)

recipe_workflow <- add_recipe(base_workflow, recipe)
formula_workflow <- add_formula(base_workflow, mpg ~ cyl + log(disp))

fit_recipe_workflow <- fit(recipe_workflow, mtcars)
fit_formula_workflow <- fit(formula_workflow, mtcars)

# The preprocessor is either a recipe or a formula
pull_workflow_preprocessor(recipe_workflow)
pull_workflow_preprocessor(formula_workflow)

# The `spec` is the parsnip spec before it has been fit.
# The `fit` is the fit parsnip model.
pull_workflow_spec(fit_formula_workflow)
pull_workflow_fit(fit_formula_workflow)

# The mold is returned from `hardhat::mold()`, and contains the
# predictors, outcomes, and information about the preprocessing
# for use on new data at `predict()` time.
pull_workflow_mold(fit_recipe_workflow)

# A useful shortcut is to extract the prepped recipe from the workflow
pull_workflow_prepped_recipe(fit_recipe_workflow)

# That is identical to
identical(
  pull_workflow_mold(fit_recipe_workflow)$blueprint$recipe,
  pull_workflow_prepped_recipe(fit_recipe_workflow)
)
}
