% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wm_opts.R
\name{wm_opts}
\alias{wm_opts}
\title{Set/get global webmorph options}
\usage{
wm_opts(...)
}
\arguments{
\item{...}{One of four: (1) nothing, then returns all options as a list; (2) a name of an option element, then returns its value; (3) a name-value pair which sets the corresponding option to the new value (and returns nothing), (4) a list with option-value pairs which sets all the corresponding arguments.}
}
\value{
a list of options, values of an option, or nothing
}
\description{
See \code{\link[=wm_opts_defaults]{wm_opts_defaults()}} for explanations of the default options.
}
\examples{

wm_opts() # see all options

wm_opts("verbose") # see value of webmorph.verbose

\dontrun{
# set value of webmorph.verbose
wm_opts(verbose = FALSE) 

# set multiple options
opts <- list(fill = "black",
             pt.color = "white", 
             line.color = "red")
wm_opts(opts)
}

}
\seealso{
\code{\link[=wm_opts_defaults]{wm_opts_defaults()}}
}
