% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{mlabel}
\alias{mlabel}
\title{Label with magick annotations}
\usage{
mlabel(
  stimuli,
  text = TRUE,
  gravity = "north",
  location = "+0+0",
  degrees = 0,
  size = 0.1,
  font = "sans",
  style = "normal",
  weight = 400,
  kerning = 0,
  decoration = NULL,
  color = "black",
  strokecolor = NULL,
  boxcolor = NULL
)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{text}{a vector of the label text(s) or TRUE to use stimlist names}

\item{gravity}{string with gravity value from \code{magick::gravity_types}.}

\item{location}{geometry string with location relative to gravity}

\item{degrees}{rotates text around center point}

\item{size}{font size in pixels or proportion of image width (if < 1.0)}

\item{font}{string with font family such as "sans", "mono", "serif", "Times", "Helvetica", "Trebuchet", "Georgia", "Palatino" or "Comic Sans".}

\item{style}{value of \code{\link[magick:options]{magick::style_types()}}: "Undefined", "Any", "Italic", "Normal", "Oblique"}

\item{weight}{thickness of th e font, 400 is normal and 700 is bold.}

\item{kerning}{increases or decreases whitespace between letters}

\item{decoration}{value of \code{\link[magick:options]{magick::decoration_types()}}: "LineThrough" "None", "Overline", "Underline"}

\item{color}{a vector of the label colour(s)}

\item{strokecolor}{adds a stroke (border around the text)}

\item{boxcolor}{adds a background color}
}
\value{
stimlist with labelled images
}
\description{
Label image using \link[magick:painting]{magick::image_annotate}. All arguments are vectorised over the stimuli and values are recycled or truncated if there are fewer or more than stimuli. Setting a font, weight, style only works if your imagemagick is compiled with fontconfig support.
}
\examples{
stimuli <- demo_stim()
mlabel(stimuli,
       text = c("CHINWE", "GEORGE"), 
       gravity = c("north", "south"),
       color = "red")
}
\seealso{
\code{\link[=gglabel]{gglabel()}} for a labeller using syntax like \code{\link[ggplot2:annotate]{ggplot2::annotate()}}

Visualisation functions
\code{\link{as_ggplot}()},
\code{\link{draw_tem}()},
\code{\link{gglabel}()},
\code{\link{label}()},
\code{\link{plot.stimlist}()},
\code{\link{plot.stim}()},
\code{\link{plot_rows}()},
\code{\link{plot_stim}()}
}
\concept{viz}
