\name{print.wpst}
\alias{print.wpst}
\title{Prints out basic information about a wpst class object}
\usage{
\method{print}{wpst}(x, \dots)
}
\arguments{
\item{x}{The wpst object that you wish to print info about}
\item{\dots}{Other arguments}
}
\description{
Prints out basic information about a wpst class object generated by
the, e.g., \code{\link{wpst}} function.

\emph{Note:} stationary wavelet packet objects are now known as nondecimated
	wavelet packet objects.
}
\details{
Description says all
}
\value{
Nothing
}
\seealso{\code{\link{wpst}}}
\examples{
v <- rnorm(128)
vwpst <- wpst(v)
\dontrun{print(vwpst)}
#Class 'wpst' : Stationary Wavelet Packet Transform Object:
#	~~~  : List with 5 components with names
#		wpst nlevels avixstart filter date
#
#$wpst is a coefficient vector
#
#Created on : Fri Mar  5 15:06:56 2010
#
#summary(.):
#----------
#Levels:  7
#Length of original:  128
#Filter was:  Daub cmpct on least asymm N=10
#Date:  Fri Mar  5 15:06:56 2010
}
\author{G P Nason}
\keyword{print}
