% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theorical_comparison.R
\name{.get_VS_input_list}
\alias{.get_VS_input_list}
\title{.get_VS_input_list}
\usage{
.get_VS_input_list(
  value_sets_3L = NULL,
  value_sets_5L = NULL,
  value_sets_XW = NULL,
  value_sets_XWR = NULL,
  value_sets_others = NULL
)
}
\arguments{
\item{value_sets_3L}{(Optional) A character vector specifying the country value sets for EQ5D-3L version.}

\item{value_sets_5L}{(Optional) A character vector specifying the country value sets for EQ5D-5L version.}

\item{value_sets_XW}{(Optional) A character vector specifying the country value sets for EQ5D-XW version.}

\item{value_sets_XWR}{(Optional) A character vector specifying the country value sets for EQ5D-XWR version.}

\item{value_sets_others}{(Optional) A list of lists specifying the inputs for other instruments. Each list within the main list should be named and contain a data frame ("df"), a column specifying the health states ("stateColumn"), and a column specifying the utility values ("utilityColumn").}
}
\value{
A list containing input specifications for each provided value set. Each element of the list is a list including three elements: "df", which is a dataframe, "stateColumn" which specifies the name of the column in the "df" dataframe that contains health states, and "utilityColumn" which is the name of the column in the "df" dataframe that contains utility values.
}
\description{
This function generates a list of input specifications based on provided EQ5D versions and value sets.
}
\keyword{internal}
