% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_comparison.R
\name{density_plot_empirical}
\alias{density_plot_empirical}
\title{density_plot_empirical}
\usage{
density_plot_empirical(
  df,
  utility_columns,
  graph_title = "",
  x_axis_title = "Index Value",
  x_min_value = NULL,
  x_max_value = NULL,
  y_axis_title = "Density",
  y_min_value = NULL,
  y_max_value = NULL,
  legend_name = "",
  color_palette = NULL,
  line_types = NULL
)
}
\arguments{
\item{df}{A data frame containing the utility and weight columns.}

\item{utility_columns}{A character vector specifying the names of utility columns.}

\item{graph_title}{A character string specifying the title of the graph. Default is an empty string.}

\item{x_axis_title}{A character string specifying the title of the x-axis. Default is "Index Value".}

\item{x_min_value}{A numeric specifying the minimum value for the x-axis. Default is NULL.}

\item{x_max_value}{A numeric specifying the maximum value for the x-axis. Default is NULL.}

\item{y_axis_title}{A character string specifying the title of the y-axis. Default is "Density".}

\item{y_min_value}{A numeric specifying the minimum value for the y-axis. Default is NULL.}

\item{y_max_value}{A numeric specifying the maximum value for the y-axis. Default is NULL.}

\item{legend_name}{A character string specifying the name of the legend. Default is "".}

\item{color_palette}{A character vector specifying the colors for the density lines. Default is a predefined color palette.}

\item{line_types}{A character vector specifying the line types for the density lines. Default is solid.}
}
\value{
A ggplot object visualizing the density of utilities for the specified EQ5D versions and other instruments value sets.
}
\description{
This function creates a smoothed kernel density plot of the empirical distribution of utility values in a given data frame.
}
\examples{
dim.names.3L <- c("mobility", "selfcare", "activity", "pain", "anxiety")
cdta$EQ5D3L <- eq5dsuite::eq5d3l(x = cdta, 
                                country = "US", 
                                dim.names = dim.names.3L)
dim.names.5L <- c("mobility5L", "selfcare5L", "activity5L", "pain5L", "anxiety5L")
cdta$EQ5D5L <- eq5dsuite::eq5d5l(x = cdta, 
                                country = "US", 
                                dim.names = dim.names.5L)
cdta$EQXW <- eq5dsuite::eqxw(x = cdta, 
                            country = "US", 
                            dim.names = dim.names.5L)
density_plot_empirical(df = cdta, utility_columns = c("EQ5D3L", "EQ5D5L", "EQXW"))
}
