% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confrontation.R
\docType{methods}
\name{as.data.frame,confrontation-method}
\alias{as.data.frame,confrontation-method}
\title{Confrontation object to data frame}
\usage{
\S4method{as.data.frame}{confrontation}(x, row.names = NULL,
  optional = FALSE, ...)
}
\arguments{
\item{x}{Object to coerce}

\item{row.names}{ignored}

\item{optional}{ignored}

\item{...}{arguments passed to other methods}
}
\value{
A \code{data.frame} with columns
\itemize{
  \item{\code{key} Where relevant, and only if \code{key} was specified in the call to \code{\link{confront}}}
  \item{\code{name} Name of the rule}
  \item{\code{value} Value after evaluation}
  \item{\code{expression} evaluated expression}
}
}
\description{
Confrontation object to data frame
}
\examples{
cf <- check_that(women, height > 0, sd(weight) > 0)
as.data.frame(cf)

# add id-column
women$id <- letters[1:15]
i <- indicator(mw = mean(weight), ratio = weight/height)
as.data.frame(confront(women, i, key="id"))

}
