% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule.R, R/expressionset.R
\docType{methods}
\name{variables}
\alias{variables}
\alias{variables,rule-method}
\alias{variables,list-method}
\alias{variables,data.frame-method}
\alias{variables,environment-method}
\alias{variables,expressionset-method}
\title{Extract variable names}
\usage{
variables(x, ...)

\S4method{variables}{rule}(x, ...)

\S4method{variables}{list}(x, ...)

\S4method{variables}{data.frame}(x, ...)

\S4method{variables}{environment}(x, ...)

\S4method{variables}{expressionset}(x, as = c("vector", "matrix", "list"),
  dummy = FALSE, ...)
}
\arguments{
\item{x}{An R object}

\item{...}{Arguments to be passed to other methods.}

\item{as}{how to return variables: 
\itemize{
  \item{\code{'vector'}} Return the uniqe vector of variables occurring in \code{x}.
  \item{\code{'matrix'}} Return a boolean matrix, each row representing a rule, each column representing a variable.
  \item{\code{'list'}} Return a named \code{list}, each entry containing a character vector with variable names.
}}

\item{dummy}{Also retrieve transient variables set with the \code{:=} operator.}
}
\description{
Extract variable names
}
\section{Methods (by class)}{
\itemize{
\item \code{rule}: Retrieve unique variable names

\item \code{list}: Alias to \code{names.list}

\item \code{data.frame}: Alias to \code{names.data.frame}

\item \code{environment}: Alias to \code{ls}

\item \code{expressionset}: Variables occuring in \code{x} either as a single list, or per rule.
}}

\examples{

v <- validator(
  root = y := sqrt(x)
 , average = mean(x) > 3
 , sum = x + y == z
)
variables(v)
variables(v,dummy=TRUE)
variables(v,matrix=TRUE)
variables(v,matrix=TRUE,dummy=TRUE)


}
\seealso{
\itemize{
\item{\code{\link{names,expressionset-method}}, \code{\link{length,expressionset-method}}}
\item{\code{\link{description}}, \code{\link{label}}, \code{\link{created}}, \code{\link{origin}}}
}
}
