% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_beta_mixture_nsamples.R
\name{draw_beta_mixture_nsamples}
\alias{draw_beta_mixture_nsamples}
\title{Draw n samples from a mixture of beta distributions}
\usage{
draw_beta_mixture_nsamples(n, chips_mult, weights = NULL)
}
\arguments{
\item{n}{The number of samples to be drawn.}

\item{chips_mult}{A data frame or matrix containing expert weights.
Rows should represent experts, columns should represent bins / weights.}

\item{weights}{An optional vector containing the weight assigned to each expert. Defaults to equal weights.}
}
\value{
A numeric vector containing samples from a pooled distribution of expert opinions.
}
\description{
Draws samples from a mixture of beta distributions, representing pooled weights on
the informative component of a robust MAP prior, as elicited from experts via the roulette method.
}
\examples{
rweights <- draw_beta_mixture_nsamples(
n = 50,
chips_mult = rbind(
  c(0, 0, 0, 0, 2, 3, 3, 2, 0, 0),
  c(0, 0, 0, 1, 2, 4, 2, 1, 0, 0),
  c(0, 0, 0, 2, 2, 2, 2, 2, 0, 0)
  ))
rweights

}
