% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_polygon.R
\name{type_polygon}
\alias{type_polygon}
\title{Polygon plot type}
\usage{
type_polygon(density = NULL, angle = 45)
}
\arguments{
\item{density}{the density of shading lines, in lines per inch.  The
    default value of \code{NULL} means that no shading lines are drawn.
    A zero value of \code{density} means no shading nor filling whereas
    negative values and \code{NA} suppress shading (and so allow
    color filling).}

\item{angle}{the slope of shading lines, given as an angle
     in degrees (counter-clockwise).}
}
\description{
Type function for plotting polygons.
Arguments are passed to \code{\link[graphics]{polygon}}.
}
\examples{
# "polygon" type convenience character string
tinyplot(1:9, c(2,1,2,1,NA,2,1,2,1), type = "polygon")

# Use `type_polygon()` to pass extra arguments for customization
tinyplot(1:9, c(2,1,2,1,NA,2,1,2,1), type = type_polygon(density = c(10, 20)))

}
