% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_as.R
\name{import_as}
\alias{import_as}
\title{Load R-package and its Re-exports and/or its (Reverse) Dependencies Under a Single Alias}
\usage{
import_as(
  alias,
  main_package,
  re_exports = TRUE,
  dependencies = NULL,
  extensions = NULL,
  lib.loc = .libPaths(),
  loadorder = c("dependencies", "main_package", "extensions")
)
}
\arguments{
\item{alias}{a syntactically valid non-hidden name giving the alias object
where the package(s) are to be loaded into. \cr
This name can be given either as a single string (i.e. \code{"alias."}),
or as a one-sided formula with a single term (i.e. \code{~ alias.}).}

\item{main_package}{a single string,
giving the name of the main package to load under the given alias.}

\item{re_exports}{\code{TRUE} or \code{FALSE}.
\itemize{
\item If \code{re_exports = TRUE} the re-exports from the \code{main_package}
are added to the alias together with the main package.
This is the default, as it is analogous to the behaviour of base R's \link{::} operator.
\item If \code{re_exports = FALSE}, these re-exports are not added together with the main package.
The user can still load the packages from which the re-exported functions came from,
by specifying them in the \code{dependencies} argument.
}}

\item{dependencies}{an optional character vector,
giving the names of the dependencies of the
\code{main_package} to be loaded also under the alias. \cr
Defaults to \code{NULL}, which means no dependencies are loaded. \cr
See \link{pkg_get_deps} to quickly get dependencies from a package. \cr}

\item{extensions}{an optional character vector,
giving the names of the extensions of the
\code{main_package} to be loaded also under the alias. \cr
Defaults to \code{NULL}, which means no extensions are loaded. \cr}

\item{lib.loc}{character vector specifying library search path
(the location of R library trees to search through). \cr
The \code{lib.loc} argument would usually be \code{.libPaths()}. \cr
See also \link[base]{loadNamespace}.}

\item{loadorder}{the character vector \cr
\code{c("dependencies", "main_package", "extensions")}, \cr
or some re-ordering of this character vector,
giving the relative load order of the groups of packages. \cr
See Details section for more information. \cr}
}
\value{
A locked environment object, similar to the output of \link[base]{loadNamespace},
with the name as specified in the \code{alias} argument,
will be created. \cr
This object, referred to as the "(package) alias object",
will contain the exported functions from the specified package(s). \cr
The alias object will be placed in the current environment
(like the global environment, or the environment within a function). \cr
\cr
To use, for example, function "some_function()" from alias "alias.", use: \cr
\code{alias.$some_function()} \cr
To see the special attributes of this alias object, use \link{attr.import}. \cr
To "unload" the package alias object, simply remove it (i.e. \code{rm(list="alias.")}). \cr
}
\description{
The \code{import_as()} function
imports the namespace of an R-package,
and optionally also its re-exports, dependencies, and extensions,
all under the same alias.
The specified alias will be placed in the current environment
(like the global environment, or the environment within a function). \cr
}
\details{
\bold{Expanded Definitions of Some Arguments} \cr
\itemize{
\item "Re-exports" are functions that are defined in the dependencies of the
\code{main_package}, but are re-exported in the namespace of the \code{main_package}.
\item "Dependencies" are here defined as any R-package appearing in the
"Depends", "Imports", or "LinkingTo" fields of the Description file of the
\code{main_package}. So no recursive dependencies.
\item "Extensions" are here defined as
direct reverse-depends or direct reverse-imports.
It does not matter if these are CRAN or non-CRAN packages.
However, the intended meaning of an extension is not merely a reverse dependency,
but a package that actually extends the functionality of the
\code{main_package}. \cr \cr
}

\bold{Why Aliasing Multiple Packages is Useful} \cr
To use an R-package with its extension packages or dependencies,
whilst avoiding the disadvantages of attaching a package (see \link{tinycodet_import}),
one would traditionally use the \link[base]{::} operator like so: \cr

\if{html}{\out{<div class="sourceCode r">}}\preformatted{main_package::some_function1()
extension1::some_function2()
extension2::some_function3()
}\if{html}{\out{</div>}}

This becomes cumbersome as more packages are needed and/or
as the package name(s) become longer. \cr
The \code{import_as()} function avoids this issue
by allowing multiple \bold{related} packages to be loaded under a single alias,
allowing one to code like this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{import_as(
   ~ alias., "main_package",
   extensions = c("extension1", "extension2"),
   lib.loc = .libPaths()
)
alias.$some_function1()
alias.$some_function2()
alias.$some_function3()
}\if{html}{\out{</div>}}

Thus loading a package, or multiple directly related packages, under a single alias,
which \code{import_as()} provides, avoids the above issues.
Loading (a) package(s) under an alias is known as "aliasing" (a) package(s). \cr
\cr
Notice that the \code{import_as()} function has the \code{lib.loc} argument,
allowing to specify the library path,
which the \link[base]{::} operator does not directly provide. \cr
\cr
\cr
\bold{Alias Naming Recommendation} \cr
To keep package alias object names easily distinguishable from other objects
that can also be subset with the \link[base]{$} operator,
I recommend ending (not starting!) all alias names
with a dot (\code{.}) or underscore (\code{_}). \cr
\cr
\cr
\bold{Regarding the Load Order} \cr
The order of the character vector given in
the \code{dependencies} and \code{extensions} arguments matters.
If multiple packages share objects with the same name,
the objects of the package named last will overwrite those of the earlier named packages. \cr
\cr
The \code{loadorder} argument defaults to the character vector \cr
\code{c("dependencies", "main_package", "extensions")}, \cr
which is the recommended setting. \cr
This setting results in the following load order: \cr
\enumerate{
\item The dependencies, \bold{in the order specified by the \code{depenencies} argument}.
\item The main_package (see argument \code{main_package}),
including re-exports (if \code{re_exports = TRUE}).
\item The extensions, \bold{in the order specified by the \code{extensions} argument}. \cr \cr
}

\bold{Other Details} \cr
The \code{import_as()} function
does not support loading base/core R under an alias. \cr
\cr
}
\examples{
\dontshow{if (all(c("data.table", "tidytable") \%installed in\% .libPaths())) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

import_as( # this creates the 'tdt.' object
  "tdt.", "data.table", extensions = "tidytable"
)
# same as:
import_as(
  ~ tdt., "data.table", extensions = "tidytable"
)


\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tinycodet_import]{tinycodet_import()}}
}
