% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computation.R
\name{matrix_process}
\alias{matrix_process}
\title{Process matrix}
\usage{
matrix_process(
  matrix,
  method = c("raw", "zscore", "fc", "log2fc", "log1p"),
  ...
)
}
\arguments{
\item{matrix}{A matrix.}

\item{method}{Method to use for processing the matrix.}

\item{...}{Other arguments passed to the method.}
}
\value{
A processed matrix.
}
\description{
Process matrix
}
\examples{
m <- simulate_sparse_matrix(10, 10)
matrix_process(m, method = "raw")
matrix_process(m, method = "zscore")
matrix_process(m, method = "fc")
matrix_process(m, method = "log2fc")
matrix_process(m, method = "log1p")
m <- as_matrix(m)
matrix_process(m, method = function(x) x / rowMeans(x))
}
