% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_to_rownames.R
\name{column_to_rownames}
\alias{column_to_rownames}
\title{Add a Column as Rownames}
\usage{
column_to_rownames(x, loc = 1)
}
\arguments{
\item{x}{An object that can be coerced to a \code{\link[base]{data.frame}}.}

\item{loc}{The column location as either an integer or string index location.
Must be unique row names.}
}
\value{
Returns a \code{\link[base]{data.frame}} with the specified column
moved to rownames.
}
\description{
Takes an existing column and uses it as rownames instead.  This is useful
when turning a \code{\link[base]{data.frame}} into a \code{\link[base]{matrix}}.
Inspired by the \pkg{tibble} package's \code{column_to_row} which is now
deprecated if done on a \pkg{tibble} object.  By coercing to a
\code{\link[base]{data.frame}} this problem is avoided.
}
\examples{
state_dat <- data.frame(state.name, state.area, state.center, state.division)
column_to_rownames(state_dat)
column_to_rownames(state_dat, 'state.name')
}

