% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_list.R
\name{bind_list}
\alias{bind_list}
\title{Row Bind a List of Named Dataframes or Vectors}
\usage{
bind_list(x, id.name = "id", content.name = "content", ...)
}
\arguments{
\item{x}{A named \code{\link[base]{list}} of
\code{\link[base]{data.frame}}s or \code{\link[base]{vector}}.}

\item{id.name}{The name to use for the column created from the \code{\link[base]{list}}.}

\item{content.name}{The name to use for the column created from the \code{\link[base]{list}}
of \code{\link[base]{vector}}s (only used if \code{x} is  \code{\link[base]{vector}}).}

\item{\ldots}{ignored.}
}
\value{
Returns a \code{\link[data.table]{data.table}} with the \code{\link[base]{names}}
from the \code{\link[base]{list}} as an \code{id} column.
}
\description{
Deprecated, use \code{\link[textshape]{tidy_list}} instead.
}
\examples{
\dontrun{
bind_list(list(p=1:500, r=letters))
bind_list(list(p=mtcars, r=mtcars, z=mtcars, d=mtcars))

## 2015 Vice-Presidential Debates Example
if (!require("pacman")) install.packages("pacman")
pacman::p_load(rvest, magrittr, xml2)

debates <- c(
    wisconsin = "110908",
    boulder = "110906",
    california = "110756",
    ohio = "110489"
)

lapply(debates, function(x){
    xml2::read_html(paste0("http://www.presidency.ucsb.edu/ws/index.php?pid=", x)) \%>\%
        rvest::html_nodes("p") \%>\%
        rvest::html_text() \%>\%
        textshape::split_index(grep("^[A-Z]+:", .)) \%>\%
        textshape::combine() \%>\%
        textshape::split_transcript() \%>\%
        textshape::split_sentence()
}) \%>\%
    textshape::bind_list("location")
}
}

