% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexicon_loughran.R
\name{lexicon_loughran}
\alias{lexicon_loughran}
\title{Loughran-McDonald sentiment lexicon}
\source{
\url{https://sraf.nd.edu/loughranmcdonald-master-dictionary/}
}
\usage{
lexicon_loughran(
  dir = NULL,
  delete = FALSE,
  return_path = FALSE,
  clean = FALSE,
  manual_download = FALSE
)
}
\arguments{
\item{dir}{Character, path to directory where data will be stored. If
\code{NULL}, \link[rappdirs]{user_cache_dir} will be used to determine path.}

\item{delete}{Logical, set \code{TRUE} to delete dataset.}

\item{return_path}{Logical, set \code{TRUE} to return the path of the dataset.}

\item{clean}{Logical, set \code{TRUE} to remove intermediate files. This can
greatly reduce the size. Defaults to FALSE.}

\item{manual_download}{Logical, set \code{TRUE} if you have manually
downloaded the file and placed it in the folder designated by running
this function with \code{return_path = TRUE}.}
}
\value{
A tibble with 4,150 rows and 2 variables:
\describe{
  \item{word}{An English word}
  \item{sentiment}{Indicator for sentiment: "negative", "positive",
  "litigious", "uncertainty", "constraining", or "superfluous"}
}
}
\description{
English sentiment lexicon created for use with financial documents. This
lexicon labels words with six possible sentiments important in financial
contexts: "negative", "positive", "litigious", "uncertainty", "constraining",
or "superfluous".
}
\details{
Citation info:

This dataset was published in Loughran, T. and McDonald, B. (2011),
``When Is a Liability Not a Liability? Textual Analysis, Dictionaries, and
10-Ks.'' The Journal of Finance, 66: 35-65.

article\{loughran11, \cr
author  = \{Loughran, Tim and McDonald, Bill\}, \cr
title   = \{When Is a Liability Not a Liability? Textual Analysis, Dictionaries, and 10-Ks\}, \cr
journal = \{The Journal of Finance\}, \cr
volume  = \{66\}, \cr
number  = \{1\}, \cr
pages   = \{35-65\}, \cr
doi     = \{10.1111/j.1540-6261.2010.01625.x\}, \cr
url     = \{https://onlinelibrary.wiley.com/doi/abs/10.1111/j.1540-6261.2010.01625.x\}, \cr
eprint  = \{https://onlinelibrary.wiley.com/doi/pdf/10.1111/j.1540-6261.2010.01625.x\}, \cr
year    = \{2011\} \cr
\}
}
\examples{
\dontrun{
lexicon_loughran()

# Custom directory
lexicon_loughran(dir = "data/")

# Deleting dataset
lexicon_loughran(delete = TRUE)

# Returning filepath of data
lexicon_loughran(return_path = TRUE)
}
}
\seealso{
Other lexicon: 
\code{\link{lexicon_afinn}()},
\code{\link{lexicon_bing}()},
\code{\link{lexicon_nrc_eil}()},
\code{\link{lexicon_nrc_vad}()},
\code{\link{lexicon_nrc}()}
}
\concept{lexicon}
\keyword{datasets}
