% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-textnets.R
\name{doc_similarity}
\alias{doc_similarity}
\title{Find a similarities between documents}
\usage{
doc_similarity(x, y = NULL, method, wv = NULL)
}
\arguments{
\item{x}{Document-term matrix with terms as columns.}

\item{y}{Optional second matrix (default = \code{NULL}).}

\item{method}{Character vector indicating similarity method, including
projection, cosine, wmd, and centroid (see Details).}

\item{wv}{Matrix of word embedding vectors (a.k.a embedding model)
with rows as words. Required for "wmd" and "centroid"
similarities.}
}
\description{
Given a document-term matrix (DTM) this function returns the
similarities between documents using a specified method (see details).
The result is a square document-by-document similarity matrix (DSM),
equivalent to a weighted adjacency matrix in network analysis.
}
\details{
Document similarity methods include:
\itemize{
\item projection: finds the one-mode projection matrix from the two-mode DTM
using \code{tcrossprod()} which measures the shared vocabulary overlap
\item cosine: compares row vectors using cosine  similarity
\item jaccard: compares proportion of common words to unique words in
both documents
\item wmd: uses word mover's distance to compare documents (requires word
embedding vectors)
\item centroid: represents each document as a centroid of their respective
vocabulary, then uses cosine similarity to compare centroid vectors
(requires word embedding vectors)
}
}
\author{
Dustin Stoltz
}
