% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableSave.R
\name{tableSave}
\alias{tableSave}
\title{Save a tableplot}
\usage{
tableSave(tab, filename = paste(tab$dataset, ".pdf", sep = ""),
  device = default_device(filename), path = NULL, scale = 1,
  width = par("din")[1], height = par("din")[2], dpi = 300,
  onePage = TRUE, ...)
}
\arguments{
\item{tab}{a \link{tabplot-object}, or a list of \link{tabplot-object}s, which are either stacked horizontally or put on multiple pages (for pdf only)}

\item{filename}{filename with extention (pdf, eps, svg, wmf, png, jpg, bmp, or tiff)}

\item{device}{device, automatically extracted from filename extension}

\item{path}{path to save to}

\item{scale}{scaling factor}

\item{width}{width (in inches)}

\item{height}{height (in inches)}

\item{dpi}{dpi to use for raster graphics}

\item{onePage}{if true, multiple tab objects are stacked horizontally, else they are printed on multiple pages}

\item{...}{other arguments passed to \code{\link[=plot.tabplot]{plot}} or the used graphics device}
}
\description{
Save a tableplot in pdf, eps, svg, wmf, png, jpg, bmp, or tiff format.
}
\examples{
\dontrun{
require(ggplot2)
data(diamonds)

# default tableplot
tab <- tableplot(diamonds)

# save tableplot
tableSave(tab, filename="diamonds.png", title="Shine on you Crazy Diamond!!!")
}
}
\keyword{save}
\keyword{tableplot}
