% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix2text.R
\name{matrix2text}
\alias{matrix2text}
\title{matrix2text}
\usage{
matrix2text(
  x,
  legend = NULL,
  unifyMatrix = TRUE,
  correctComma = FALSE,
  na.rm = TRUE,
  forceClass = NULL,
  expandAbbreviations = TRUE,
  superscript2bracket = TRUE,
  decodeP = FALSE,
  standardPcoding = FALSE,
  noSign2p = FALSE,
  bracketHandling = FALSE,
  dfHandling = TRUE,
  rotate = FALSE,
  unlist = FALSE,
  addTableName = TRUE,
  split = FALSE
)
}
\arguments{
\item{x}{A character matrix or list of character matrices.}

\item{legend}{A list with table legend codes extracted from table caption and/or footnote with 'tableParser::legendCodings()'.}

\item{unifyMatrix}{Logical. If TRUE, matrix cells are unified for better post-processing.}

\item{correctComma}{Logical. If TRUE and 'unifyMatrix=TRUE', decimal sign commas are converted to dots.}

\item{na.rm}{Logical. If TRUE, NA cells are set to empty cells.}

\item{forceClass}{character. Set matrix-specific handling to one of c("tabled result", "correlation", "matrix", "text").}

\item{expandAbbreviations}{Logical. If TRUE, detected abbreviations are expanded to label detected in table caption/footnote with 'tableParser::legendCodings()'.}

\item{superscript2bracket}{Logical. If TRUE, detected superscript codings are inserted inside parentheses.}

\item{decodeP}{Logical. If TRUE, imputes the converts the detected p-value codings to text with seperator ';;' (e.g., '1.23*' -> '1.23;; p<.01')}

\item{standardPcoding}{Logical. If TRUE, and no other detection of p-value coding is detected, standard coding of p-values is assumed to be: * p<.05, ** p<.01, and *** p<.001.}

\item{noSign2p}{Logical. If TRUE, imputes 'p>maximum of coded p-values' to cells that are not coded to be significant.}

\item{bracketHandling}{Logical. If TRUE and if possible, decodes numbers in brackets.}

\item{dfHandling}{Logical. If TRUE, detected sample size N in the caption/footnote is inserted as degrees of freedom (N-2) to r- and t-values that are reported without degrees of freedom.}

\item{rotate}{Logical. If TRUE, matrix content is parsed by column.}

\item{unlist}{Logical. If TRUE, output is returned as a vector with parsed text from all listed matrices; else, a list with parsed text from each matrix is returned as a list.}

\item{addTableName}{Logical. If TRUE and unlist=TRUE, the table number is added in front of unlisted text lines.}

\item{split}{Logical. If TRUE, multi-model tables are split before being processed.}
}
\value{
Character vector with a parsed and human-readable form of the input table. The result vector can be further processed with standardStats() to extract and structure the statistical standard test results only.
}
\description{
Converts character matrix content to a screen reader-like readable character string. The parsing is performed row-wise in standard mode.
}
\examples{
# some random data
x<-rnorm(100)
y<-x+rnorm(100)

# a model result table...
mod<-round(summary(lm(y~x))$coefficients,3)
rnames<-c("",rownames(mod))
cnames<-colnames(mod)
mod<-rbind(cnames,mod)
mod<-cbind(rnames,mod)

# ...as character result matrix
x<-unname(mod)
x

## parse matrix to text vector
# - as is
matrix2text(x,unifyMatrix=FALSE)
# - with unified content
matrix2text(x,unifyMatrix=TRUE)

## processing of a matrix with two header lines
x<-rbind(c("","A","A","B","B"),x)
x
matrix2text(x,unifyMatrix=FALSE)

## processing of a matrix with two header lines and grouping column [,1]
x<-cbind(c("","","C","D"),x)
x
matrix2text(x,unifyMatrix=FALSE)
}
