% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_row_in_column_css.R
\name{add_css_rows_in_column}
\alias{add_css_rows_in_column}
\title{Add css to tableHTML's columns' rows.}
\usage{
add_css_rows_in_column(tableHTML, css, column)
}
\arguments{
\item{tableHTML}{A tableHTML object created by the tableHTML function.}

\item{css}{A list of two elements. The first element of the list
should be an atomic vector of length 1 with the style definition (e.g. background-color). 
The second element will be an atomic vector with the same length as the column, which will
contain the style definitions' values (e.g. red). Check the examples for more information.}

\item{column}{A character atomic vector of length 1, with the name of the column 
or a numeric atomic vector with the positions of the columns where the 
style definitions will be applied on. Only one column must be provided. 
If the rownames are included the column name is "tableHTML_rownames"
and the position is 0. If row_groups are included the column name is "tableHTML_row_groups"
and the position is -1.}
}
\value{
A tableHTML object.
}
\description{
\code{add_css_rows_in_column} will add css to a tableHTML's individual rows within a column
}
\details{
\code{add_css_rows_in_column} will add css to a tableHTML's individual rows within a column.
Only one css style definition can be used, and multiple values (same length as the column)
will be applied to the rows within the column. As an example a list of different colours
can be provided for all the rows within a column.
}
\examples{
tableHTML(mtcars) \%>\%
  add_css_rows_in_column(css = list('background-color', 
                                   rep(c('red', 'green'), each = 16)),
                        column = 'mpg')

tableHTML(mtcars) \%>\%
  add_css_column(css = list('border', '3px solid blue'),
                 columns = c('mpg', 'disp', 'rownames')) \%>\%
  add_css_rows_in_column(css = list(c('background-color'), 
                                   rep(c('red', 'green'), each = 16)),
                        column = 'mpg')
                        
                        
tableHTML(mtcars) \%>\%
  add_css_rows_in_column(css = list(c('background-color'), 
                                   rep(c('red', 'green'), each = 16)),
                        column = 'mpg') \%>\%
  add_css_column(css = list('border', '3px solid blue'),
                 columns = c('mpg', 'disp', 'rownames')) 


}
