% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv.plot.R
\name{surv.plot}
\alias{surv.plot}
\title{Publication Ready Kaplan-Meier Estimator}
\arguments{
\item{fit}{An object of class \link[survival:survfit]{survival::survfit} containing survival data.}

\item{reference.arm}{A character string specifying the reference arm for comparison.}

\item{time.unit}{A character string specifying the time unit which was used to create the \code{fit} object.
\emph{Note:} \code{time.unit} will not convert the time of the \code{fit} object.

Option include: \code{"day"}, \code{"week"}, \code{"month"},\code{"year"}.}

\item{y.unit}{A character string specifying the unit of the y-axis.

Option include: \code{"probability"}, \code{"percent"}.}

\item{censoring.mark}{A logical parameter indicating whether censoring events
should be marked on the survival curves. Default is \code{TRUE}.}

\item{censoring.cex}{A numeric value specifying the size of the marks for
censored patients. Default is \code{1.3}.}

\item{conf.int}{A numeric value controlling the confidence interval on survival curves.
Default is \code{0.95}, corresponding to a 95\% confidence interval.
Values between \code{0} and \code{1} represent the desired confidence interval.
If set to \code{0}, no confidence intervals are displayed.}

\item{conf.band}{A logical parameter indicating whether to display the
confidence band on the survival curves. Default is \code{TRUE}.}

\item{conf.band.col}{A colour which is used for the confidence band.
Can accept a single colour value or a vector of colours.}

\item{conf.band.transparent}{A numeric value between \code{0} and \code{1} controlling the
transparency of the confidence band. Default is \code{0.25}.}

\item{conf.line.lty}{A strings specifying the line type of the confidence lines.

Options include: \code{"blank"}, \code{"solid"}, \code{"dashed"}, \code{"dotted"}, \code{"dotdash"},
\code{"longdash"}, \code{"twodash"}.
Default is \code{"blank"}.}

\item{conf.line.lwd}{A numeric value specifying the width of the confidence lines.}

\item{conf.type}{Transformation type for the confidence interval.

Options include: \code{"log"}, \code{"log-log"}, \code{"plain"}, \code{"logit"}, \code{"arcsin"}.
Default is \code{log-log}.}

\item{grid}{A logical parameter specifying whether to draw a grid.
Default is \code{FALSE}.}

\item{col}{A colour which is used for the survival curves.
Can accept a single colour value  or a vector of colours.}

\item{main}{Title of the plot.}

\item{sub}{Subtitle of the plot.
Note: A subtitle is only displayed if no risk table is shown.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{xticks}{A numeric vector specifying the ticks of the x-axis.

Can be specified as \code{seq(from = , to = , by = )}.
\itemize{
\item \code{from}: starting value
\item \code{to}: end value
\item \code{by}: number; increment of the sequence
}}

\item{yticks}{A numeric vector specifying the ticks of the y-axis.

Can be specified as \code{seq(from = , to = , by = )}.
\itemize{
\item \code{from}: starting value
\item \code{to}: end value
\item \code{by}: number; increment of the sequence
}

\emph{Note}: It should always be specified as probability.}

\item{xlab.pos}{Defines the margin line where the X-axis label (xlab) is displayed,
starting at 0 and counting outwards. Default is 1.5.}

\item{ylab.pos}{Defines the margin line the Y-axis label (ylab) is displayed,
starting at 0 counting outwards. Default is 3.}

\item{xlab.cex}{A numeric value specifying the size of the X-axis label.}

\item{ylab.cex}{A numeric value specifying the size of the Y-axis label.}

\item{cex}{A numeric value specifying the size of all all text elements
(labels, annotations, etc.).}

\item{axis.cex}{A numeric value specifying the size of the axis elements.}

\item{bty}{Determines the style of the box drawn around the plot.

Options include: \code{"n"} ,\code{"o"},\code{"c"},\code{"u"}. Default is \code{"n"}.}

\item{lty}{A string specifying the line type of of the curve(s).

Options include: \code{"blank"}, \code{"solid"}, \code{"dashed"}, \code{"dotted"}, \code{"dotdash"},
\code{"longdash"}, \code{"twodash"}.}

\item{lwd}{A numeric value specifying the width of the line.}

\item{legend}{A logical parameter specifying whether to display legend.
By default, the legend is displayed if there is more than one arm.}

\item{legend.position}{Position of the legend.

Options include: "c(x,y)"\verb{, }"bottomright"\verb{, }"bottom"\verb{, }"bottomleft"\verb{, }"left"`,}

\item{legend.name}{A vector of character string specifying of the name(s) of the arm(s).}

\item{legend.cex}{A numeric value specifying the size of the legend text.}

\item{legend.text.font}{Font style of the legend text.
Possible values:
\itemize{
\item \code{1} normal
\item \code{2} bold
\item \code{3} italic
\item \code{4} bold and italic
}}

\item{legend.title}{Title of the legend.}

\item{legend.title.cex}{A numeric value specifying the size of the legend title.}

\item{segment.type}{A numeric value specifying the layout of the segment.
Possible values:
\itemize{
\item \code{1} full width
\item \code{2} half width
\item \code{3} vertical and horizontal segment (default)
}}

\item{segment.timepoint}{A single value or a vector of fixed time points
to be drawn as segment(s).}

\item{segment.quantile}{A single value or a vector of fixed quantile to be
drawn as segment(s). Example: 0.5 corresponds to median.}

\item{segment.main}{Title of the segment text.}

\item{segment.confint}{A logical parameter specifying whether to display
the confidence interval for the segment.

\emph{NOTE:} Only possible to set \code{segment.confint = FALSE} if there are two arms.
Default is \code{TRUE}.}

\item{segment.annotation}{Position of the segment annotation.

Options include: \code{c(x,y)},\code{"bottomleft"}, \code{"left"}, \code{"right"}, \code{"top"}, \code{"none"}.}

\item{segment.annotation.two.lines}{A logical parameter to force that the
annotation is displayed on two lines even if there is only one arm. This
parameter only has an effect if there is only one arm. Default: FALSE}

\item{segment.annotation.col}{A colour which is used for the segment annotation.
Can accept a single colour value or a vector of colours.}

\item{segment.annotation.space}{Spacing between the text in units of x-coordinates.}

\item{segment.col}{A colour which is used for the segment.
Can accept a single colour value.}

\item{segment.lty}{A strings specifying the line type of the segment(s).

Options include: \code{"blank"}, \code{"solid"}, \code{"dashed"}, \code{"dotted"}, \code{"dotdash"},
\code{"longdash"}, \code{"twodash"}.}

\item{segment.lwd}{A numeric value specifying the width of the segment line.}

\item{segment.cex}{A numeric value specifying the size of the segment text size.}

\item{segment.font}{A numeric value specifying the font face.
Possible values:
\itemize{
\item \code{1} plain
\item \code{2} bold
\item \code{3} italic
\item \code{4} bold-italic
}}

\item{segment.main.font}{A numeric value specifying the font face for the segment text.
Possible values:
\itemize{
\item \code{1} plain
\item \code{2} bold
\item \code{3} italic
\item \code{4} bold-italic
}}

\item{stat.fit}{An object of class \link[survival:survfit]{survival::survfit} containing survival data.
Used for calculation of statistics, allowing to add stratification factors.

\emph{Note:} If not specified the \code{fit} object will be used for the \code{stat}.}

\item{stat}{Statistics displayed in the plot.

Options:
\itemize{
\item \code{"logrank"} gives the p value of the conducted logrank test using \verb{survdiff\{survival\}}.
To tests if there is a difference between two or more survival curves.
\item \code{"coxph"}  gives the hazard ratio (HR) and its CI (default: 95\% CI)of the conducted
Cox proportional hazards regression using \verb{coxph\{survival\}}. \emph{Note}: This option
only works if there are two arms.
\item \code{"coxph_logrank"} combines the hazard ratio (HR), its CI (default: 95\% CI) and the
logrank test. \emph{Note:} This option only works if there are two arms.
\item \code{'none'} no statistic is displayed (default).
}

Note: Confidence interval can be adjusted with the argument \code{stat.conf.int}.}

\item{stat.position}{Position where the \code{stat} should be displayed.

Options include: \code{c(x,y)},\code{"bottomleft"}, \code{"left"}, \code{"right"},
\code{"top"}, \code{"topright"},\code{"bottomright"}, \code{"none"}.}

\item{stat.conf.int}{A numeric value controlling the confidence interval on
the \code{stat} (hazard ratio). Default is \code{0.95}, corresponds to a 95\% confidence interval.
Values between \code{0} and \code{1} represent the desired confidence interval.}

\item{stat.col}{A colour which is used for the statistics text.
Can accept a single colour value or a vector of colours.}

\item{stat.cex}{A numeric value specifying the size of the `statistics text size.}

\item{stat.font}{The font face of the statistics
Possible values:
\itemize{
\item \code{1} plain
\item \code{2} bold
\item \code{3} italic
\item \code{4} bold-italic
}}

\item{risktable}{A logical parameter indicating whether to draw risk table.
Default is \code{TRUE}.}

\item{risktable.censoring}{A logical parameter indicating whether to display number of censored patients.
Default is \code{FALSE}.}

\item{risktable.pos}{Defines on which margin line of the xlab is displayed,
starting at 0 counting outwards.
Default is at line \code{3}.}

\item{risktable.name}{Names of the arms for the risk table.}

\item{risktable.cex}{A numeric value specifying the size of the risk table text size.}

\item{risktable.col}{A coulour which is used for the risk table.
Can accept a single colour value or a vector of colours.
Default is \code{black}.

\emph{Note:} If \code{risktable.col = TRUE} then the colours of the curves are used.}

\item{risktable.title}{Title of risk table.}

\item{risktable.title.font}{Font style of the risk table.
Possible values:
\itemize{
\item \code{1} normal
\item \code{2} bold
\item \code{3} italic
\item \code{4} bold and italic
}}

\item{risktable.title.col}{A colour which is used for the risk table title.
Can accept a single colour value.}

\item{risktable.title.position}{A numeric value specifying the position of the title on the x-axis.}

\item{risktable.title.cex}{A numeric value specifying the size of the risk table title size.}

\item{risktable.name.cex}{A numeric value specifying the size of the risk table legend name size.}

\item{risktable.name.font}{Font style of the risk table legend name(s).
Possible values:
\itemize{
\item \code{1} normal
\item \code{2} bold
\item \code{3} italic
\item \code{4} bold and italic
}}

\item{risktable.name.col}{A colour which is used for the risk table name.
Can accept a single colour value.}

\item{risktable.name.position}{A numeric value specifying the position of the legend name(s) on the x-axis.}

\item{margin.bottom}{Specifies the bottom margin of the plotting area in line units.
Default is \code{5}.}

\item{margin.left}{Specifies the left margin of the plotting area in line units.
Default is \code{6} (with risktable) or \code{4} (without risktable).}

\item{margin.top}{Specifies the top margin of the plotting area in line units.
Default is \code{3}.}

\item{margin.right}{Specifies the right margin of the plotting area in line units.
Default is \code{2}.}

\item{theme}{Built-in layout options.
Options include: ("none", "SAKK", "Lancet", "JCO", "WCLC", "ESMO")}
}
\value{
Kaplan-Meier curves of the input \code{fit},
incorporating various statistics and layout option(s).
}
\description{
Provide an open-source, user-friendly tool designed to enhance the creation
and customization of Kaplan-Meier plots and incorporating various statistics
and layout customization options using \code{surv.plot(fit, ...)}.
}
\details{
The survSAKK R package provides the \code{\link[=surv.plot]{surv.plot()}} function, facilitating
Kaplan-Meier survival analysis. Designed with user-friendliness and efficiency
in mind. Offering robust tool for analysing survival data. It utilises the
functionalities of \code{\link[survival:survfit]{survival::survfit()}}.

For a comprehensive manual visit: \url{https://sakk-statistics.github.io/survSAKK/articles/surv.plot.html}
}
\examples{
 require(survival)
 require(survSAKK)

# Create survival object
 fit <- survfit(Surv(lung$time/365.25*12, status) ~ sex, data = lung)

# Generate survival plots
 surv.plot(fit = fit,
   time.unit = "month",
   legend.name =  c("male", "female"))

}
\references{
Therneau T (2024). A Package for Survival Analysis in R. R package version 3.5-8, \url{https://CRAN.R-project.org/package=survival}.

Terry M. Therneau, Patricia M. Grambsch (2000). Modeling Survival Data: Extending the Cox Model. Springer, New York. ISBN 0-387-98784-3.
}
\seealso{
\itemize{
\item \code{\link[survival:survfit]{survival::survfit()}} which this function wraps.
}
}
\author{
Vithersan Somasundaram and Katrin Gysel
}
