% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{subprocess}
\alias{subprocess}
\alias{subprocess-package}
\title{Manage Subprocesses in R}
\description{
Cross-platform child process management modelled after Python's
\code{subprocess} module.
}
\details{
This R package extends R's capabilities of starting and
handling child processes. It brings the capability of alternating
read from and write to a child process, communicating via signals,
terminating it and handling its exit status (return code).

With R's standard \link[base:system]{base::system} and \link[base:system2]{base::system2}
functions one can start a new process and capture its output but
cannot directly write to its standard input. Another tool, the
\link[parallel:mclapply]{parallel::mclapply} function, is aimed at replicating
the current session and is limited to operating systems that come
with the \code{fork()} system call.
}
\references{
http://github.com/lbartnik/subprocess

http://docs.python.org/3/library/subprocess.html
}
