% Generated by roxygen2 (4.0.0): do not edit by hand
\name{addSize}
\alias{addSize}
\title{Add color information.}
\usage{
addSize(data, kit = NA, bins = TRUE, ignore.case = FALSE, debug = FALSE)
}
\arguments{
\item{data}{data.frame with at least columns 'Marker' and 'Allele'.}

\item{kit}{data.frame with columns 'Marker', 'Allele', and 'Size'.}

\item{bins}{logical TRUE alleles get size from corresponding bin.
If FALSE the size is calculated from the locus offset and repeat unit.}

\item{ignore.case}{logical TRUE case in marker names are ignored.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with additional columns for added size.
}
\description{
\code{addSize} add size information to alleles.
}
\details{
Adds a column 'Size' with the fragment size in base pair (bp) for each allele as
estimated from kit bins OR calculated from offset and repeat. The bins
option return NA for alleles not in bin. The calculate option handles
all named alleles including micro variants (e.g. '9.3').
Handles 'X' and 'Y' by replacing them with '1' and '2'.
}

