% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_extract.R
\name{str_extract_all}
\alias{str_extract_all}
\title{Extract matching patterns from a string}
\source{
Adapted from the \href{https://stringr.tidyverse.org/}{stringr} package.
}
\usage{
str_extract_all(string, pattern, simplify = FALSE)
}
\arguments{
\item{string}{Input vector.
Either a character vector, or something coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression,
as described in \link[base:regex]{base::regex}.
Control options with \code{\link[=regex]{regex()}}.

Match a fixed string (i.e. by comparing only bytes), using \code{\link[=fixed]{fixed()}}.
This is fast, but approximate.}

\item{simplify}{If \code{FALSE}, the default, returns a list of character vectors.
If \code{TRUE} returns a character matrix.}
}
\value{
A list of character vectors if \code{simplify = FALSE},
or a character matrix if \code{simplify = TRUE}.
}
\description{
Dependency-free drop-in alternative for \code{stringr::str_extract_all()}.
}
