% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sub.R
\name{stri_sub}
\alias{stri_sub}
\alias{stri_sub<-}
\alias{stri_sub_replace}
\title{Extract a Substring From or Replace a Substring In a Character Vector}
\usage{
stri_sub(str, from = 1L, to = -1L, length)

stri_sub(str, from=1L, to=-1L, length, omit_na=FALSE) <- value

stri_sub_replace(..., replacement, value = replacement)
}
\arguments{
\item{str}{a character vector}

\item{from}{an integer vector giving the start indexes or a two-column matrix
of type \code{cbind(from, to)}}

\item{to}{an integer vector giving the end indexes; mutually exclusive with
\code{length} and \code{from} being a matrix}

\item{length}{an integer vector giving the substring lengths;
mutually exclusive with \code{to} and \code{from} being a matrix}

\item{omit_na}{a single logical value; indicates whether missing values
in any of the indexes or in \code{value} leave the corresponding input string
unchanged [replacement function only]}

\item{value}{a character vector defining the replacement strings
[replacement function only]}

\item{...}{arguments to be passed to \code{stri_sub<-}}

\item{replacement}{alias of \code{value} [wherever applicable]}
}
\value{
\code{stri_sub} and \code{stri_sub_replace} return a character vector.
\code{stri_sub<-} changes the \code{str} object in-place.
}
\description{
\code{stri_sub} extracts particular substrings at code point-based
index ranges provided. Its replacement version allows to substitute
(in-place) parts of
a string with given replacement strings. \code{stri_sub_replace}
is its \pkg{magrittr}'s pipe-operator-friendly variant that returns
a copy of the input vector.

For extracting/replacing multiple substrings from/within each string, see
\code{\link{stri_sub_all}}.
}
\details{
Vectorized over \code{str}, [\code{value}], \code{from} and
(\code{to} or \code{length}). Parameters
\code{to} and \code{length} are mutually exclusive.

Indexes are 1-based, i.e., the start of a string is at index 1.
For negative indexes in \code{from} or \code{to},
counting starts at the end of the string.
For instance, index -1 denotes the last code point in the string.
Non-positive \code{length} gives an empty string.

Argument \code{from} gives the start of a substring to extract.
Argument \code{to} defines the last index of a substring, inclusive.
Alternatively, its \code{length} may be provided.

If \code{from} is a two-column matrix, then these two columns are
used as \code{from} and \code{to}, respectively, and anything passed
explicitly as \code{from} or \code{to} is ignored.
Such types of index matrices are generated by \code{\link{stri_locate_first}}
and \code{\link{stri_locate_last}}. If extraction based on
\code{\link{stri_locate_all}} is needed, see
\code{\link{stri_sub_all}}.

In \code{stri_sub}, out-of-bound indexes are silently
corrected. If \code{from} > \code{to}, then an empty string is returned.

In \code{stri_sub<-}, some configurations of indexes may work as
substring 'injection' at the front, back, or in middle.


If both \code{to} and \code{length} are provided,
\code{length} has priority over \code{to}.

Note that for some Unicode strings, the extracted substrings might not
be well-formed, especially if input strings are not NFC-normalized
(see \code{\link{stri_trans_nfc}}),
include byte order marks, Bidirectional text marks, and so on.
Handle with care.
}
\examples{
s <- 'Lorem ipsum dolor sit amet, consectetur adipisicing elit.'
stri_sub(s, from=1:3*6, to=21)
stri_sub(s, from=c(1,7,13), length=5)
stri_sub(s, from=1, length=1:3)
stri_sub(s, -17, -7)
stri_sub(s, -5, length=4)
(stri_sub(s, 1, 5) <- 'stringi')
(stri_sub(s, -6, length=5) <- '.')
(stri_sub(s, 1, 1:3) <- 1:2)

x <- c('12 3456 789', 'abc', '', NA, '667')
stri_sub(x, stri_locate_first_regex(x, '[0-9]+')) # see stri_extract_first
stri_sub(x, stri_locate_last_regex(x, '[0-9]+'))  # see stri_extract_last

stri_sub_replace(x, stri_locate_first_regex(x, '[0-9]+'),
    omit_na=TRUE, replacement='***') # see stri_replace_first
stri_sub_replace(x, stri_locate_last_regex(x, '[0-9]+'),
    omit_na=TRUE, replacement='***') # see stri_replace_last

stri_sub(x, stri_locate_first_regex(x, '[0-9]+'), omit_na=TRUE) <- '***'
print(x)

\dontrun{x \%>\% stri_sub_replace(1, 5, replacement='new_substring')}
}
\seealso{
Other indexing: 
\code{\link{stri_locate_all_boundaries}()},
\code{\link{stri_locate_all}()},
\code{\link{stri_sub_all}()}
}
\concept{indexing}
