% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_locate_bound.R
\name{stri_locate_all_boundaries}
\alias{stri_locate_all_boundaries}
\alias{stri_locate_last_boundaries}
\alias{stri_locate_first_boundaries}
\alias{stri_locate_all_words}
\alias{stri_locate_last_words}
\alias{stri_locate_first_words}
\title{Locate Text Boundaries}
\usage{
stri_locate_all_boundaries(str, omit_no_match = FALSE, ...,
  opts_brkiter = NULL)

stri_locate_last_boundaries(str, ..., opts_brkiter = NULL)

stri_locate_first_boundaries(str, ..., opts_brkiter = NULL)

stri_locate_all_words(str, omit_no_match = FALSE, locale = NULL)

stri_locate_last_words(str, locale = NULL)

stri_locate_first_words(str, locale = NULL)
}
\arguments{
\item{str}{character vector or an object coercible to}

\item{omit_no_match}{single logical value; if \code{FALSE},
then 2 missing values will indicate that there are no text boundaries}

\item{...}{additional settings for \code{opts_brkiter}}

\item{opts_brkiter}{a named list with \pkg{ICU} BreakIterator's settings,
see \code{\link{stri_opts_brkiter}};
\code{NULL} for default break iterator, i.e., \code{line_break}}

\item{locale}{\code{NULL} or \code{""} for text boundary analysis following
the conventions of the default locale, or a single string with
locale identifier, see \link{stringi-locale}}
}
\value{
For \code{stri_locate_all_*}, a list of \code{length(str)} integer matrices
is returned. The first column gives the start positions
of substrings between located boundaries, and the second column gives
the end positions. The indexes are code point-based, thus
they may be passed, e.g., to \code{\link{stri_sub}} or \code{\link{stri_sub_all}}.
Note that you get two \code{NA}s in one row
if there is no match (and \code{omit_no_match} is \code{FALSE})
or there are missing data in the input vector.

\code{stri_locate_first_*} and \code{stri_locate_last_*},
return an integer matrix with
two columns, giving the start and end positions of the first
or the last matches, respectively, and two \code{NA}s if there is no match.
}
\description{
These functions locate text boundaries
(like character, word, line, or sentence boundaries).
Use \code{stri_locate_all_*} to locate all the matches.
\code{stri_locate_first_*} and \code{stri_locate_last_*}
give the first or the last matches, respectively.
}
\details{
Vectorized over \code{str}.

For more information on text boundary analysis
performed by \pkg{ICU}'s \code{BreakIterator}, see
\link{stringi-search-boundaries}.

In case of \code{stri_locate_*_words},
just like in \code{\link{stri_extract_all_words}} and \code{\link{stri_count_words}},
\pkg{ICU}'s word \code{BreakIterator} iterator is used
to locate the word boundaries, and all non-word characters
(\code{UBRK_WORD_NONE} rule status) are ignored.
This is function is equivalent to a call to
\code{stri_locate_*_boundaries(str, type="word", skip_word_none=TRUE, locale=locale)}
}
\examples{
test <- "The\\u00a0above-mentioned    features are very useful. Kudos to their developers."
stri_locate_all_boundaries(test, type="line")
stri_locate_all_boundaries(test, type="word")
stri_locate_all_boundaries(test, type="sentence")
stri_locate_all_boundaries(test, type="character")
stri_locate_all_words(test)

stri_extract_all_boundaries("Mr. Jones and Mrs. Brown are very happy.
So am I, Prof. Smith.", type="sentence", locale="en_US@ss=standard") # ICU >= 56 only

}
\seealso{
Other search_locate: \code{\link{stri_locate_all}},
  \code{\link{stringi-search}}

Other indexing: \code{\link{stri_locate_all}},
  \code{\link{stri_sub_all}}, \code{\link{stri_sub}}

Other locale_sensitive: \code{\link{\%s<\%}},
  \code{\link{stri_compare}},
  \code{\link{stri_count_boundaries}},
  \code{\link{stri_duplicated}},
  \code{\link{stri_enc_detect2}},
  \code{\link{stri_extract_all_boundaries}},
  \code{\link{stri_opts_collator}},
  \code{\link{stri_order}}, \code{\link{stri_sort}},
  \code{\link{stri_split_boundaries}},
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_unique}}, \code{\link{stri_wrap}},
  \code{\link{stringi-locale}},
  \code{\link{stringi-search-boundaries}},
  \code{\link{stringi-search-coll}}

Other text_boundaries: \code{\link{stri_count_boundaries}},
  \code{\link{stri_extract_all_boundaries}},
  \code{\link{stri_opts_brkiter}},
  \code{\link{stri_split_boundaries}},
  \code{\link{stri_split_lines}},
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_wrap}},
  \code{\link{stringi-search-boundaries}},
  \code{\link{stringi-search}}
}
\concept{indexing}
\concept{locale_sensitive}
\concept{search_locate}
\concept{text_boundaries}
