% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stringi-search-boundaries}
\alias{stringi-search-boundaries}
\title{Text Boundary Analysis in \pkg{stringi}}
\description{
Text boundary analysis is the process of locating linguistic boundaries
while formatting and handling text.
}
\details{
Examples of the boundary analysis process process include:

\itemize{
\item Locating appropriate points to word-wrap text to fit
within specific margins while displaying or printing,
see \code{\link{stri_wrap}} and \code{\link{stri_split_boundaries}}.
\item Counting characters, words, sentences, or paragraphs,
see \code{\link{stri_count_boundaries}}.
\item Making a list of the unique words in a document,
cf. \code{\link{stri_extract_words}} and then \code{\link{stri_unique}}.
\item Capitalizing the first letter of each word
or sentence, see also \code{\link{stri_trans_totitle}}.
\item Locating a particular unit of the text (for example,
finding the third word in the document),
see \code{\link{stri_locate_boundaries}}.
}

Generally, text boundary analysis is a locale-dependent operation.
For example, in Japanese and Chinese one does not separate words with spaces
- a line break can occur even in the middle of a word.
These languages have punctuation and diacritical
marks that cannot start or end a line, so this must also be taken into account.

\pkg{stringi} uses \pkg{ICU}'s \code{BreakIterator} to locate specific
text boundaries. Note that the \code{BreakIterator}'s behavior
may be controlled in come cases, see \code{\link{stri_opts_brkiter}}.
\itemize{
\item The \code{character} boundary iterator tries to match what a user
would think of as a ``character''  -- a basic unit of a writing system
for a language -- which may be more than just a single Unicode code point.
\item The \code{word} boundary iterator locates the boundaries
of words, for purposes such as ``Find whole words'' operations.
\item The \code{line_break} iterator locates positions that would
be appropriate points to wrap lines when displaying the text.
\item On the other hand, a break iterator of type \code{sentence}
locates sentence boundaries.
}

For technical details on different classes of text boundaries refer
to the \pkg{ICU} User Guide, see below.
}
\references{
\emph{Boundary Analysis} -- ICU User Guide,
\url{http://userguide.icu-project.org/boundaryanalysis}
}
\seealso{
Other locale_sensitive: \code{\link{\%s!==\%}},
  \code{\link{\%s!=\%}}, \code{\link{\%s<=\%}},
  \code{\link{\%s<\%}}, \code{\link{\%s===\%}},
  \code{\link{\%s==\%}}, \code{\link{\%s>=\%}},
  \code{\link{\%s>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_boundaries}},
  \code{\link{stri_count_words}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_locate_boundaries}},
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-coll}}

Other stringi_general_topics: \code{\link{stringi-arguments}};
  \code{\link{stringi-encoding}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-package}};
  \code{\link{stringi-search-charclass}};
  \code{\link{stringi-search-coll}};
  \code{\link{stringi-search-fixed}};
  \code{\link{stringi-search-regex}};
  \code{\link{stringi-search}}

Other text_boundaries: \code{\link{stri_count_boundaries}},
  \code{\link{stri_count_words}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_locate_boundaries}},
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_brkiter}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_lines}},
  \code{\link{stri_split_lines1}},
  \code{\link{stri_split_lines1}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_wrap}}; \code{\link{stringi-search}}
}

