% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_locate_all_coll}
\alias{stri_locate_all_coll}
\alias{stri_locate_first_coll}
\alias{stri_locate_last_coll}
\title{Locate Occurrences of a Canonically Equivalent Pattern}
\usage{
stri_locate_all_coll(str, pattern, opts_collator = NULL)

stri_locate_first_coll(str, pattern, opts_collator = NULL)

stri_locate_last_coll(str, pattern, opts_collator = NULL)
}
\arguments{
\item{str}{character vector}

\item{pattern}{character vector}

\item{opts_collator}{a named list with \pkg{ICU} Collator's settings
as generated with \code{\link{stri_opts_collator}}; \code{NULL}
for default settings}
}
\value{
For \code{stri_locate_all_coll},
a list of \code{max(length(str), length(pattern))} integer matrices
is returned.
The first column gives the start positions
of matches, and the second column gives the end positions.
Moreover, you may gen two \code{NA}s in one row
for no match or \code{NA} arguments.

For \code{stri_locate_first_coll} and \code{stri_locate_last_coll},
you get an integer matrix with \code{max(length(str), length(pattern))} rows,
and two columns, giving the start and end positions of the first
or the last matches, respectively, and \code{NA}s iff not found.
}
\description{
These functions find the indices, at which
a given pattern matches a substring of the input string.
}
\details{
Vectorized over \code{str} and \code{pattern}.

See \link{stringi-search-coll} for more details on
locale-sensitive text searching in \pkg{stringi}.


Note the difference between  \code{stri_locate_last_coll}
and \code{\link{stri_locate_last_regex}} for overlapping pattern matches.
In \code{stri_locate_last_coll}, search is done from-the-end.
}
\examples{
stri_locate_all_coll(c('AaaaaaaA', 'AAAA'), 'a')
stri_locate_first_coll(c('AaaaaaaA', 'aaa', 'AAA'), 'a')
stri_locate_last_coll(c('AaaaaaaA', 'aaa', 'AAA'), 'a')

#first row is 1-2 like in locate_first
stri_locate_all_coll('bbbbb', 'bb')
stri_locate_first_coll('bbbbb', 'bb')
# but last row is 3-4, unlike in locate_last,
# keep this in mind [overlapping pattern match OK]!
stri_locate_last_coll('bbbbb', 'bb')

locate <- stri_locate_first_coll('stringi - REXAMINE', letters)
rownames(locate) <- letters
locate
}
\seealso{
Other indexing: \code{\link{stri_locate_all_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_last_charclass}},
  \code{\link{stri_locate_last_charclass}};
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_fixed}};
  \code{\link{stri_locate_all_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_last_regex}},
  \code{\link{stri_locate_last_regex}};
  \code{\link{stri_locate_all}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_first}};
  \code{\link{stri_locate_last}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_locate}}; \code{\link{stri_sub}},
  \code{\link{stri_sub<-}}

Other locale_sensitive: \code{\link{\%!==\%}},
  \code{\link{\%!=\%}}, \code{\link{\%<=\%}},
  \code{\link{\%<\%}}, \code{\link{\%===\%}},
  \code{\link{\%==\%}}, \code{\link{\%>=\%}},
  \code{\link{\%>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_coll}};
  \code{\link{stri_detect_coll}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_all_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_last_coll}},
  \code{\link{stri_extract_last_coll}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_replace_all_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_last_coll}},
  \code{\link{stri_replace_last_coll}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_coll}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-coll}}

Other search_coll: \code{\link{stri_count_coll}};
  \code{\link{stri_detect_coll}};
  \code{\link{stri_extract_all_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_last_coll}},
  \code{\link{stri_extract_last_coll}};
  \code{\link{stri_replace_all_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_last_coll}},
  \code{\link{stri_replace_last_coll}};
  \code{\link{stri_split_coll}};
  \code{\link{stringi-search-coll}};
  \code{\link{stringi-search}}

Other search_locate: \code{\link{stri_locate_all_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_first_charclass}},
  \code{\link{stri_locate_last_charclass}},
  \code{\link{stri_locate_last_charclass}};
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_fixed}};
  \code{\link{stri_locate_all_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_first_regex}},
  \code{\link{stri_locate_last_regex}},
  \code{\link{stri_locate_last_regex}};
  \code{\link{stri_locate_all}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_first}};
  \code{\link{stri_locate_last}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_locate}}; \code{\link{stringi-search}}
}

