% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdmod_lavaan.R
\name{stdmod_lavaan}
\alias{stdmod_lavaan}
\title{Standardized Moderation Effect and Its Bootstrap CI in 'lavaan'}
\usage{
stdmod_lavaan(fit, x, y, w, x_w, boot_ci = FALSE, R = 100, conf = 0.95, ...)
}
\arguments{
\item{fit}{The SEM output by \code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its wrappers.}

\item{x}{The name of the focal variable in the model, the variable with
its effect on the outcome variable being moderated.}

\item{y}{The name of the outcome variable (dependent variable) in the model.}

\item{w}{The name of the moderator in the model.}

\item{x_w}{The name of the product term (x * w) in the model. It can be
the variable generated by the colon operator, e.g., \code{"x:w"},
which is only in the model and not in the original data set.}

\item{boot_ci}{Boolean. Whether nonparametric bootstrapping will be
conducted. Default is \code{FALSE}.}

\item{R}{The number of nonparametric bootstrapping samples. Default is 100.
Set this to at least 2000 in actual use.}

\item{conf}{The level of confidence. Default is .95, i.e., 95\%.}

\item{...}{Optional arguments to be passed to \code{\link[boot:boot]{boot::boot()}}. Parallel
processing can be used by adding the appropriate arguments in
\code{\link[boot:boot]{boot::boot()}}.}
}
\value{
A list of class \code{stdmod_lavaan} with these elements:
\itemize{
\item \code{stdmod}: The standardized moderation effect.
\item \code{ci}: The nonparametric bootstrap confidence interval. \code{NA} if
confidence interval not requested.
\item \code{boot_out}: The raw output from \code{\link[boot:boot]{boot::boot()}}. \code{NA} if
confidence interval not requested.
\item \code{fit}: The original fit object.
}
}
\description{
Compute the standardized moderation effect in a structural
equation model fitted by \code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its wrappers and
form the nonparametric bootstrap confidence interval.
}
\details{
\code{\link[=stdmod_lavaan]{stdmod_lavaan()}} accepts a \link[lavaan:lavaan-class]{lavaan::lavaan} object, the
structural equation model output returned
by \code{\link[lavaan:lavaan]{lavaan::lavaan()}} and its wrappers (e.g, \code{\link[lavaan:sem]{lavaan::sem()}}) and computes
the standardized moderation effect using the formula in the appendix of
Cheung, Cheung, Lau, Hui, and Vong (2022).

The standard deviations of the focal variable (the variable with its effect
on the outcome variable being moderated), moderator, and outcome
variable (dependent variable) are computed from the implied
covariance matrix returned by
\code{\link[lavaan:lavInspect]{lavaan::lavInspect()}}. Therefore, models fitted to data sets with missing
data (e.g., with \code{missing = "fiml"}) are also supported.

If nonparametric bootstrap confidence interval is requested with \code{R}
bootstrap samples, the model will be fitted \code{R} times to these samples,
and the standardized
moderation effect will be computed in each sample. This ensures that all
components used in the computation, including the standard deviations, are
also computed from the bootstrapping samples.

Note that the computation can be slow because \code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its
wrappers
will be called
\code{R} times.
}
\examples{

#Load a test data of 500 cases

dat <- test_mod1
library(lavaan)
mod <-
"
med ~ iv + mod + iv:mod + cov1
dv ~ med + cov2
"
fit <- sem(mod, dat)

# Compute the standardized moderation effect
out_noboot <- stdmod_lavaan(fit = fit,
                            x = "iv",
                            y = "med",
                            w = "mod",
                            x_w = "iv:mod")
out_noboot

# Compute the standardized moderation effect and
# its percentile confidence interval using
# nonparametric bootstrapping
set.seed(8479075)
system.time(out_boot <- stdmod_lavaan(fit = fit,
                                      x = "iv",
                                      y = "med",
                                      w = "mod",
                                      x_w = "iv:mod",
                                      boot_ci = TRUE,
                                      R = 50))
# In real analysis, R should be at least 2000.
out_boot

}
\references{
Cheung, S. F., Cheung, S.-H., Lau, E. Y. Y., Hui, C. H., & Vong, W. N.
(2022) Improving an old way to measure moderation effect in standardized
units. \emph{Health Psychology}, \emph{41}(7), 502-505.
\doi{10.1037/hea0001188}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
