% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_summary_stdmod.R
\name{print.summary.std_selected}
\alias{print.summary.std_selected}
\title{Print the Summary of a 'std_selected' Class Object}
\usage{
\method{print}{summary.std_selected}(x, ...)
}
\arguments{
\item{x}{The output of \code{\link[=summary]{summary()}}.}

\item{...}{Arguments to be passed to \code{\link[=summary]{summary()}}.}
}
\value{
\code{x} is returned invisibly.
}
\description{
Print the summary generated by \code{\link[=summary]{summary()}} on the output
of \code{\link[=std_selected]{std_selected()}} or \code{\link[=std_selected_boot]{std_selected_boot()}}.
}
\examples{

# Load a sample data set

dat <- test_x_1_w_1_v_1_cat1_n_500

# Do a moderated regression by lm
lm_raw <- lm(dv ~ iv*mod + v1 + cat1, dat)

# Standardize all variables except for categorical variables.
# Interaction terms are formed after standardization.
lm_std <- std_selected(lm_raw, to_scale = ~ .,
                               to_center = ~ .)
summary(lm_std)

# With bootstrapping
# nboot = 100 just for illustration. nboot >= 2000 should be used in read
# research.
lm_std_boot <- std_selected_boot(lm_raw, to_scale = ~ .,
                                         to_center = ~ .,
                                         nboot = 100)
summary(lm_std_boot)

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
