% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/College_grades.R
\docType{data}
\name{College_grades}
\alias{College_grades}
\title{Grades at a small college}
\format{A data frame with 6146 Grades for 443 students.
  \itemize{
    \item{\code{grade}} {The letter grade for the student in this course: A is the highest.}
    \item{\code{sessionID}} {An identifier for the course taken. Courses 
    offered multiple times in one semester or across semesters have individual IDs.}
    \item{\code{sid}} {The student ID}
    \item{\code{dept}} {The department in which the course was offered. 100 is entry-level, 
    200 sophomore-level, 300 junior-level, 400 senior-level.}
    \item{\code{enroll}} {Student enrollment in the course. This includes students who are not 
    part of this sample.}
    \item{\code{iid}} {Instructor ID}
    \item{\code{gradepoint}} {A translation of the letter grade into a numerical scale. 4 is high.
    Some letter grades are not counted in a student's gradepoint average. These have \code{NA} for
    the gradepoint.}
  }}
\source{
The data were helpfully provided by the registrar of the college with the proviso 
that the de-identification steps outlined above be performed.
}
\usage{
data(College_grades)
}
\description{
These are the actual grades for 400+ individual students in the courses they took
at a small, liberal-arts college in the midwest US. All the students graduated in 2006. 
Each row corresponds to a single student in a single course. The data have been de-identified by translating the student ID, the instructor 
ID, and the name of the department. Typically a graduating student has taken about 32 courses.
As another form of de-identification, only half of the courses each student, selected randomly,
are included. Only courses with 10 or more students enrolled were included.
}
\examples{
\dontrun{
GPA <- lm(gradepoint ~ sid - 1, data = College_grades)
}
}
\keyword{datasets}

