% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftCor_v2.R
\name{shiftCor}
\alias{shiftCor}
\title{shiftCor provide the QC-RLS correction for large scale metabolomics.}
\usage{
shiftCor(samPeno, samFile, Frule = 0.8, QCspan = 0.75, degree = 2,
  imputeM = "KNN")
}
\arguments{
\item{samPeno}{a file with  the meta information.}

\item{samFile}{a file with  the expression information.}

\item{Frule}{The cut-off value for missing value filter function.}

\item{QCspan}{The smoothing parameter which controls the bias-variance tradeoff. if the QCspan is set at '0', the generalised cross-validation will be performed to avoid overfitting the observed data.}

\item{degree}{Lets you specify local constant regression (i.e., the Nadaraya-Watson estimator, degree=0), local linear regression (degree=1), or local polynomial fits (degree=2, the default).}

\item{imputeM}{The parameter for imputation method.(i.e., nearest neighbor averaging, "KNN"; minimum values for imputed variables, "min", median values for imputed variables (Group dependent) "median").}
}
\description{
shiftCor provide the QC-RLS correction for large scale metabolomics.
}
\examples{
library(statTarget)
datpath <- system.file("extdata",package = "statTarget")
samPeno <- paste(datpath,"MTBLS79_sampleList.csv", sep="/")
samFile <- paste(datpath,"MTBLS79.csv", sep="/")
shiftCor(samPeno,samFile,Frule = 0.8,QCspan = 0.75, degree = 2,imputeM = "KNN")
}

