% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{fast.eigenvalue.probability}
\alias{fast.eigenvalue.probability}
\title{Degree-based eigenvalue probability}
\usage{
fast.eigenvalue.probability(deg_prob, q_prob, all_k, z, n_iter = 5000)
}
\arguments{
\item{deg_prob}{The degree probability of the graph.}

\item{q_prob}{The excess degree probability of the graph.}

\item{all_k}{List of sorted unique degrees greater than 1 of the graph.}

\item{z}{Complex number whose real part is the eigenvalue whose probability
we want to obtain, the imaginary part is a small value (e.g., 1e-3).}

\item{n_iter}{The maximum number of iterations to perform.}
}
\value{
A complex number whose imaginary part absolute value corresponds to
the probability of the given eigenvalue.
}
\description{
\code{fast.eigenvalue.probability} returns the probability of an eigenvalue
given the degree and excess degree probability.
}
\examples{
G <- igraph::sample_smallworld(dim = 1, size = 10, nei = 2, p = 0.2)
# Obtain the degree distribution
deg_prob <- c(igraph::degree_distribution(graph = G, mode = "all"),0.0)
k_deg <- seq(1,length(deg_prob)) - 1
# Obtain the excess degree distribution
c <- sum(k_deg * deg_prob)
q_prob <- c()
for(k in 0:(length(deg_prob) - 1)){
  aux_q <- (k + 1) * deg_prob[k + 1]/c
  q_prob <- c(q_prob,aux_q)
}
# Obtain the sorted unique degrees greater than 1
all_k <- c(1:length(q_prob))
valid_idx <- q_prob != 0
q_prob <- q_prob[valid_idx]
all_k <- all_k[valid_idx]
# Obtain the probability of the eigenvalue 0
z <- 0 + 0.01*1i
eigenval_prob <- -Im(fast.eigenvalue.probability(deg_prob,q_prob,all_k,z))
eigenval_prob

}
\references{
Newman, M. E. J., Zhang, X., & Nadakuditi, R. R. (2019).
Spectra of random networks with arbitrary degrees.
Physical Review E, 99(4), 042309.
}
\keyword{eigenvalue_probability}
