% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standalone-base.R
\name{standalone}
\alias{standalone}
\title{Constructing a Standalone Market Risk}
\usage{
standalone(name, ..., list.arg = F)
}
\arguments{
\item{name}{character value of length one representing the name of the standalone market risk.
Please refer to the note Section to see which names cannot be used because there are reserved
names for the model. Using such a name would trigger an error at the standalone
construction.}

\item{...}{S3 objects of class \code{riskFactor}.}

\item{list.arg}{logical value of length one, by default set to \code{FALSE}.
It allows to use \code{...} argument to pass a list of objects of class \code{riskFactor}.}
}
\value{
a S3 object, instance of the class \code{standalone}.
}
\description{
\code{standalone} Constructor for the S3 class standalone. A \emph{standalone market risk}
  corresponds to a sub-model for market risk where only a subset of all market \code{RiskFactors} in a \code{marketRisk}
  is considered.
}
\note{
The following names are reserved for the model and cannot be used to name a
  standalone:
  \itemize{
    \item \code{marketRisk}
    \item \code{lifeRisk}
    \item \code{healthRisk}
    \item \code{nonLifeRisk}
    \item \code{scenarioRisk}
    \item \code{participationRisk}
    \item \code{participation}
    \item \code{marketParticipationRisk}
    \item \code{asset}
    \item \code{cashflow}
    \item \code{liability}
    \item \code{assetForward}
    \item \code{fxForward}
    \item \code{delta}
  }
}
\examples{
# Creating a new standalone.
standalone1 <- standalone(name = "CHF rates",
                          rate(name = "2YCHF", currency = "CHF", horizon = "k"),
                          rate(name = "10YCHF", currency = "CHF", horizon = "m"),
                          rate(name = "10YCHF", currency = "CHF", horizon = "l",
                          scale = 0.75))


}
\seealso{
\code{\link{summary.standalone}}, \code{\link{print.standalone}}.
}
