% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbox_to_SpatialPolygons.R
\name{bbox_to_SpatialPolygons}
\alias{bbox_to_SpatialPolygons}
\title{Create a SpatialPolygons Bounding Box}
\usage{
bbox_to_SpatialPolygons(x, proj4string = CRS(as.character(NA)))
}
\arguments{
\item{x}{Raster*, extent, bbox or matrix. See Details.}

\item{proj4string}{CRS object. Used to define the CRS if it is missing from x.}
}
\value{
A SpatialPolygons object.
}
\description{
Create a SpatialPolygons Bounding Box
}
\details{
This function generates a SpatialPolygons object from either
a Raster* object, an extent object, a bbox object, or a 2x2 Matrix that follows the form
generated by the bbox() function (rows = x and y, cols = min and max).
Note that with extent and matrix objects, the CRS will need to be set
manually.
}
\examples{
library("raster")
tahoe_highrez <- brick(system.file("external/tahoe_highrez.tif", package="spatial.tools"))
bbox_to_SpatialPolygons(tahoe_highrez)
tahoe_highrez_extent <- extent(tahoe_highrez)
bbox_to_SpatialPolygons(tahoe_highrez_extent,
	CRS("+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"))
tahoe_highrez_bbox <- bbox(tahoe_highrez)
bbox_to_SpatialPolygons(tahoe_highrez_bbox,
	CRS("+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"))
}
\seealso{
\code{\link[sp]{bbox}}, \code{\link{extent}}
}
\author{
Jonathan A. Greenberg
}
