% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-train.R
\name{train_nn}
\alias{train_nn}
\title{Train Network}
\usage{
train_nn(
  train_data,
  train_target,
  model,
  alpha,
  epochs,
  batch_size = nrow(train_data)
)
}
\arguments{
\item{train_data}{set of training data}

\item{train_target}{set of targets in one-hot encoded form}

\item{model}{list of weights and biases}

\item{alpha}{learning rate}

\item{epochs}{number of epochs}

\item{batch_size}{mini-batch size}
}
\value{
list of weights and biases after training
}
\description{
Train the network with specified hyperparameters.
}
\examples{
\dontrun{
model <- init_nn(784, 100, 50, 10)
mnist_train <- load_mnist_train()
train_data <- mnist_train[1]
train_target <- mnist_train[2]
train_nn(train_data, train_target, model, 0.01, 1, 10)
}
}
